package cn.smarthse.radiationTraining.core.framework.controller;


import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

/**
 * 《Controller 基础支持类》
 * 对requestParam中的参数进行预处理，例如 空字符串转换为null，类型转换，日期格式化等
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年9月8日 上午10:51:12
 */
@ControllerAdvice
public class ControllerSupport {

    /**
     * 日志对象
     */
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    protected void binderDefault(WebDataBinder binder) {
    	
    	// String 类型转换
        binder.registerCustomEditor(String.class, new PropertyEditorSupport() {
            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty(text)) {
                    setValue(null);
                } else {
                	setValue(text.trim());
                }
            }
        });
        // Date 类型转换
        binder.registerCustomEditor(Date.class, new PropertyEditorSupport() {
            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty(text)) {
                    setValue(null);
                } else {
                    setValue(DateUtil.parse(text));
                }
            }
        });

        //Integer 类型转换
        binder.registerCustomEditor(Integer.class, new PropertyEditorSupport() {
            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty(text)) {
                    setValue(null);
                } else {
                    //true 转为 1 ， false 转为 0
                    setValue("true".equalsIgnoreCase(text.trim()) ? 1 : ("false".equalsIgnoreCase(text.trim()) ? 0 : Integer.parseInt(text.trim())));
                }
            }
        });

        binder.registerCustomEditor(Byte.class, new PropertyEditorSupport() {
            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty(text)) {
                    setValue(null);
                } else {
                    setValue(Byte.valueOf(text.trim()));
                }
            }
        });

        binder.registerCustomEditor(BigDecimal.class, new PropertyEditorSupport() {
            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty(text)) {
                    setValue(null);
                } else {
                    setValue(new BigDecimal(text.trim()));
                }
            }
        });

        // Long类型转换，uuid_short()在js中显示的结构错误。
        binder.registerCustomEditor(Long.class, new PropertyEditorSupport() {
            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty(text)) {
                    setValue(null);
                } else {
                    setValue(Long.valueOf(text.trim()));
                }

            }

            @Override
            public String getAsText() {
                Object value = getValue();
                return value != null ? value.toString() : "";
            }
        });
    }

}
