package cn.smarthse.radiationTraining.core.framework.config.desensitization;

/**
 * 脱敏字段类型枚举
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/8/22 14:42
 */
public enum DesensitizationType {

    /**
     * 自定义
     */
    CUSTOM_ROLE,
    /**
     * 【用户id】不对外提供userId
     */
    USER_ID,
    /**
     * 【中文姓名】只显示第一个汉字，其他隐藏为2个星号，比如：李**
     */
    CHINESE_NAME,
    /**
     * 【身份证号】前1位 和后2位
     */
    ID_CARD,
    /**
     * 【固定电话 前四位，后两位
     */
    FIXED_PHONE,
    /**
     * 【手机号码】前三位，后4位，其他隐藏，比如135****2210
     */
    MOBILE_PHONE,
    /**
     * 【地址】只显示到地区，不显示详细地址，比如：北京市海淀区****
     */
    ADDRESS,
    /**
     * 【电子邮箱】邮箱前缀仅显示第一个字母，前缀其他隐藏，用星号代替，@及后面的地址显示，比如：d**@126.com
     */
    EMAIL,
    /**
     * 【密码】密码的全部字符都用*代替，比如：******
     */
    PASSWORD,
    /**
     * 【中国车牌】车牌中间用*代替 eg1：null -》 "" eg1："" -》 "" eg3：苏D40000 -》 苏D4***0 eg4：陕A12345D -》 陕A1****D eg5：京A123 -》 京A123 如果是错误的车牌，不处理
     */
    CAR_LICENSE,
    /**
     * 银行卡号脱敏 eg: 1101 **** **** **** 3256
     */
    BANK_CARD

}
