package cn.smarthse.radiationTraining.core.framework.config.desensitization;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.lang.annotation.*;

/**
 * 字段脱敏注解
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/8/22 14:42
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@JacksonAnnotationsInside
@JsonSerialize(using = DesensitizationSerialize.class)
public @interface Desensitization {

    /**
     * 在自定义类型的时候，start和end生效
     */
    DesensitizationType type() default DesensitizationType.CUSTOM_ROLE;
    /**
     * 开始位置（包含）
     */
    int start() default 0;
    /**
     * 结束位置（不包含）
     */
    int end() default 0;
}
