package cn.smarthse.radiationTraining.core.framework.bootstrap.properties;

import java.util.Arrays;
import java.util.List;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 *
 * 系统配置文件
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/12/6 14:12
 */
@ConfigurationProperties(prefix = "sys")
public @Data class SysProperties {

    /** AES密钥 */
    public String aesKey;

    /** 报名二维码AES密钥 */
    public String enrollQrcodeAesKey;

    /** 网站地址 */
    public String webUrl;

    /** 证书背景相对地址 */
    private String certBgImg;

    /** 证书预览地址QR */
    private String certQrUrl;

    /** 证书oss链接有效期（默认3600 * 24 * 3 秒） */
    private int certUrlExp = 3600 * 24 * 3;

    /** 定时任务是否开启，默认关闭 false */
    private boolean task = false;

    /** 特殊账号名称 */
    private String specifiedUser;

    /** 培训版本号 */
    private String trainingVersion;

    /** 文件上传支持的文件类型  */
    private List<String> supportFileTypes = Arrays.asList(new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf", "jpg", "jpeg", "png", "txt", "wmv", "mp4"});

}
