package cn.smarthse.radiationTraining.core.framework.annotation;


import java.lang.annotation.*;

/**
 *
 * 请求限制，接口防刷 默认限制5秒可访问2次
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/13 14:01
 */
@Documented
@Inherited
@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface RequestLimit {

	/**
	 * 默认为5秒内可访问maxCount次（/s）
	 */
	int second() default 5;

	/**
	 * 默认second内可访问2次（/次）
	 */
	int maxCount() default 2;

	String msg() default "请求限制！";
}
