/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.controller;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.question.SQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.ImportSQuestionData;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionEditParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionListAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.provider.ISQuestionProviderService;
import cn.smarthse.radiationTraining.modules.wqxx.service.easyexcel.SQuestionImportListener;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/s/question"})
public class SQuestionController
extends ControllerSupport {
    private final String info_prefix = "[\u9898\u5e93\u7ba1\u7406]";
    @DubboReference
    private ISQuestionProviderService questionProviderService;

    @RequiresPermissions(value={"training.knowledge.topicmanagement.edit"})
    @PostMapping(value={"add"})
    public ResponseData addForAdmin(@RequestBody SQuestionEditParam param) {
        this.logger.debug("{}-\u9898\u5e93\u6dfb\u52a0\uff1aparam-{}", (Object)"[\u9898\u5e93\u7ba1\u7406]", (Object)param);
        this.questionProviderService.addForAdmin(param);
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training.knowledge.topicmanagement.edit"})
    @PostMapping(value={"edit"})
    public ResponseData editForAdmin(@RequestBody SQuestionEditParam param) {
        this.logger.debug("{}-\u9898\u5e93\u7f16\u8f91\uff1aparam-{}", (Object)"[\u9898\u5e93\u7ba1\u7406]", (Object)param);
        this.questionProviderService.editForAdmin(param);
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training.knowledge.topicmanagement.edit"})
    @PostMapping(value={"del/batch"})
    public ResponseData delBatchForAdmin(@RequestBody SQuestionBatchAdminParam param) {
        this.logger.debug("{}-\u9898\u5e93\u6279\u91cf\u5220\u9664\uff1aparam-{}", (Object)"[\u9898\u5e93\u7ba1\u7406]", (Object)param);
        this.questionProviderService.delBatchForAdmin(param);
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training.knowledge.topicmanagement.edit"})
    @PostMapping(value={"upOrDow/batch"})
    public ResponseData upOrDownBatchForAdmin(@RequestBody SQuestionBatchAdminParam param) {
        this.logger.debug("{}-\u9898\u5e93\u6279\u91cf\u4e0a\u4e0b\u67b6\uff1aparam-{}", (Object)"[\u9898\u5e93\u7ba1\u7406]", (Object)param);
        this.questionProviderService.upOrDownBatchForAdmin(param);
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training.knowledge.topicmanagement.view"})
    @GetMapping(value={"list"})
    public ResponseData<LayuiGridData<SQuestionVo>> listForAdmin(SQuestionListAdminParam param) {
        this.logger.debug("{}-\u9898\u5e93\u5217\u8868\uff1aparam-{}", (Object)"[\u9898\u5e93\u7ba1\u7406]", (Object)param);
        param.setCurrentUserId(ShiroUtil.getLoginUserId());
        return ResponseData.success((Object)this.questionProviderService.listForAdmin(param));
    }

    @RequiresPermissions(value={"training.knowledge.topicmanagement.view"})
    @GetMapping(value={"detail"})
    public ResponseData<SQuestionVo> getDetailForAdmin(Long id) {
        this.logger.debug("{}-\u9898\u5e93\u8be6\u60c5\uff1aparam-{}", (Object)"[\u9898\u5e93\u7ba1\u7406]", (Object)id);
        return ResponseData.success((Object)this.questionProviderService.getDetailForAdmin(id));
    }

    @RequiresPermissions(value={"training.knowledge.topicmanagement.edit"})
    @PostMapping(value={"/questionsImport"}, consumes={"multipart/form-data"})
    public ResponseData<String> questionsImport(@RequestPart(value="file") MultipartFile file) {
        this.logger.debug("{}-\u5355\u9009\u6279\u91cf\u5bfc\u5165", (Object)"[\u9898\u5e93\u7ba1\u7406]");
        SQuestionImportListener readListener = new SQuestionImportListener(this.questionProviderService);
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ImportSQuestionData.class, (ReadListener)readListener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (IOException e) {
            this.logger.error("IOException\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return new ResponseData("\u5bfc\u5165\u6210\u529f\uff01");
    }
}

