/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.urgency;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.SysAreaDto;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.training.param.course.UpTuCourseRedundencyParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import java.util.HashMap;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/urgency"})
public class UrgencyController
extends ControllerSupport {
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ITuCourseProviderService tuCourseProviderService;
    @DubboReference
    private IAreaProviderService areaProviderService;

    @RequiresPermissions(value={"training:edit"})
    @GetMapping(value={"reBuildAllRelationship"})
    public ResponseData getTrainingList(String pwd) {
        this.enrollProviderService.reBuildAllRelationship(pwd);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training:edit"})
    @GetMapping(value={"analyseHSEComapnyTrain"})
    public ResponseData analyseHSEComapnyTrain(String pwd) {
        if (!pwd.equals("zhzhhbkjyxgs155fff89")) {
            throw new ServiceException("\u64cd\u4f5c\u9519\u8bef");
        }
        return ResponseData.success((Object)this.enrollProviderService.analyseHSEComapnyTrain());
    }

    @RequiresPermissions(value={"training:edit"})
    @GetMapping(value={"syncHSECompanyTrainStatus"})
    public ResponseData syncHSECompanyTrainStatus(String pwd) {
        if (!pwd.equals("zhzhhbkjyxgs155fff89")) {
            throw new ServiceException("\u64cd\u4f5c\u9519\u8bef");
        }
        String s = this.enrollProviderService.syncHSECompanyTrainStatus();
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)s);
    }

    @RequiresPermissions(value={"training:view"})
    @GetMapping(value={"getCompanyOtherInfo"})
    public ResponseData getCompanyOtherInfo(Long cid) {
        List industryCodesByCid = this.hseCompanyProviderService.getIndustryCodesByCid(cid);
        List riskFactorByCid = this.hseCompanyProviderService.getRiskFactorByCid(cid);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("\u884c\u4e1a", industryCodesByCid);
        result.put("\u5371\u5bb3\u56e0\u6570", riskFactorByCid);
        return ResponseData.success(result);
    }

    @RequiresPermissions(value={"training:edit"})
    @PostMapping(value={"updateTuCourseRedundency"})
    public ResponseData updateTuCourseRedundency(@RequestBody UpTuCourseRedundencyParam param) {
        this.tuCourseProviderService.updateRedundency(param.getTid(), param.getCourseItemId());
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training:edit"})
    @PostMapping(value={"cleanAllTuCoruseIdCache"})
    public ResponseData cleanOldTuCoruseIdCache() {
        RedisUtils.deleteObject((String)"TUCOURSE:ID");
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training:edit"})
    @PostMapping(value={"cleanAllTuCoruseCache"})
    public ResponseData cleanOldTuCoruseIdCache(String psw) {
        if (!psw.equals("sdfsdf18918sdf")) {
            throw new ServiceException("\u4e8c\u7ea7\u5bc6\u7801\u9519\u8bef");
        }
        RedisUtils.deleteObject((String)"TUCOURSE:CACHE");
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training:edit"})
    @PostMapping(value={"cleanAllBasicDirectoryCache"})
    public ResponseData cleanAllBasicDirectoryCache() {
        RedisUtils.deleteObject((String)RedisKey.getCatalogue(null));
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training:edit"})
    @PostMapping(value={"cleanAllCourseItemCache"})
    public ResponseData cleanAllCourseItemCache(String psw) {
        RedisUtils.deleteObject((String)RedisKey.getCourseItemVo(null));
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RequiresPermissions(value={"training:edit"})
    @PostMapping(value={"test"})
    public ResponseData test(Long trainAreaId, Long cAreaId) {
        SysAreaDto trainArea = this.areaProviderService.getAreaById(trainAreaId);
        SysAreaDto companyArea = this.areaProviderService.getAreaById(cAreaId);
        if (trainArea.getLevel() > companyArea.getLevel()) {
            throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
        if (trainArea.getLevel() == 1) {
            return ResponseData.success((String)"level 1\u6210\u529f");
        }
        if (trainArea.getLevel() == 2) {
            if (!trainArea.getCityId().equals(companyArea.getCityId())) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
        } else if (trainArea.getLevel() == 3) {
            if (!trainArea.getAreaId().equals(companyArea.getAreaId())) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
        } else if (trainArea.getLevel() == 4) {
            if (!trainArea.getStreetId().equals(companyArea.getStreetId())) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
        } else {
            throw new ServiceException("\u533a\u57df\u6821\u9a8c\u5931\u8d25");
        }
        return ResponseData.success((String)"\u5168\u90e8\u6210\u529f");
    }
}

