/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.training;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.param.training.AddNewTrainCourseGroupParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trainingManage/course"})
public class TrainingCourseController
extends ControllerSupport {
    @DubboReference
    private ITrainingCourseProviderService iTrainingCourseProviderService;

    @RequiresPermissions(value={"training.management.training.view"})
    @GetMapping(value={"getNewTrainCourse"})
    public ResponseData<LayuiGridData<TrainingNewCourseGroupVo>> getNewTrainCourse(TrainingSearchParam param) {
        return new ResponseData((Object)this.iTrainingCourseProviderService.getNewTrainCourse(param));
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @PostMapping(value={"saveOrUpdateNewTrainCourse"})
    public ResponseData<String> saveOrUpdateNewTrainCourse(@RequestBody AddNewTrainCourseGroupParam param) {
        this.iTrainingCourseProviderService.saveOrUpdateNewTrainCourse(param);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @GetMapping(value={"getNewCourseInfo"})
    public ResponseData<CourseItemVo> getNewCourseInfo(Long courseId) {
        return ResponseData.success((Object)this.iTrainingCourseProviderService.getNewCourseInfo(courseId));
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @GetMapping(value={"delTrainCourseRedis"})
    public ResponseData<String> delTrainCourseRedis() {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.iTrainingCourseProviderService.delTrainCourseRedis());
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @GetMapping(value={"modifyOldTrainCourseGroup"})
    public ResponseData<String> modifyOldTrainCourseGroup() {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.iTrainingCourseProviderService.modifyOldTrainCourseGroup());
    }
}

