/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.QueryUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpRedundancyInfoParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.SysUserTrainInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainEnrollCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController
extends ControllerSupport {
    @DubboReference(registry={"local_nacos"})
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysCompanyStaffProviderService sysCompanyStaffProviderService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser trainingProviderServiceForUser;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;

    @GetMapping(value={"getUserList"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<LayuiGridData<UserListVo>> getUserList(QueryUserParam param) {
        Set<Integer> loginUserSystemWideList = ShiroUtil.getLoginUserSystemWideList();
        if (loginUserSystemWideList.contains(UserSystemWideEnum.RHO.getCode()) && !loginUserSystemWideList.contains(UserSystemWideEnum.ZLWQ.getCode()) && !loginUserSystemWideList.contains(UserSystemWideEnum.MAINTENANCE.getCode())) {
            param.setIsRayWork(Integer.valueOf(1));
        }
        param.setAreaId(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        Integer zero = 0;
        Integer isTest = param.getIsTest() == null ? (ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001().booleanValue() ? param.getIsTest() : zero) : param.getIsTest();
        param.setIsTest(isTest);
        return new ResponseData((Object)this.userProviderService.getUserList(param));
    }

    @GetMapping(value={"getUser"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<UserVo> getUser(Long userId) {
        return new ResponseData((Object)this.userProviderService.getUserVo(userId));
    }

    @PostMapping(value={"saveUser"})
    @RequiresPermissions(value={"training.sys.user.edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7\u7ba1\u7406", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt)
    public ResponseData<String> saveUser(@RequestBody SaveUserParam param) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(param.getId());
        this.userProviderService.ifCanEditPersonalUserBatch(list, ShiroUtil.getLoginUsername(), null, null, ShiroUtil.getUserInfo().getAreaId());
        this.userProviderService.saveUser(param);
        return ResponseData.success();
    }

    @PostMapping(value={"del"})
    @RequiresPermissions(value={"training.sys.user.edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdsParam param) {
        UserInfo user = ShiroUtil.getShiroPrincipal().getUser();
        this.userProviderService.ifCanRmForPersonal(param.getIdList(), ShiroUtil.getLoginUsername(), null, null);
        this.userProviderService.del(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @PostMapping(value={"forbiddenAdmin"})
    @RequiresPermissions(value={"training.sys.user.edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenParam param) {
        this.userProviderService.ifCanEditPersonalUserBatch(param.getIdList(), ShiroUtil.getLoginUsername(), null, null, ShiroUtil.getUserInfo().getAreaId());
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @ApiEncrypt(response=true)
    @PostMapping(value={"resetPassword"})
    @RequiresPermissions(value={"training.sys.user.edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u91cd\u7f6e\u5bc6\u7801", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_reset)
    public ResponseData<String> resetPassword(@RequestBody IdsParam param) {
        this.userProviderService.ifCanEditPersonalUserBatch(param.getIdList(), ShiroUtil.getLoginUsername(), null, null, ShiroUtil.getUserInfo().getAreaId());
        this.userProviderService.resetPassword(param.getIdList(), param.getLoginUserId());
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)"Zyj@2022");
    }

    @GetMapping(value={"getTrainingList"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<LayuiGridData<TrainingPersonEnrollVo>> getTrainingList(PersonEnrollSearchParam param) {
        param.setAreaId(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        return new ResponseData((Object)this.trainingProviderServiceForUser.listPersnoEnroll(param));
    }

    @GetMapping(value={"getMyTrainingBaseInfo"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<SysUserTrainInfoVo> getMyTrainingBaseInfo(Long tid, Long uid, Long enrollDetailId) {
        return new ResponseData((Object)this.trainingProviderServiceForUser.getMyTrainingBaseInfoForUser(tid, uid, enrollDetailId));
    }

    @GetMapping(value={"getEnrollDetailList"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<LayuiGridData<TrainEnrollCourseVo>> getEnrollDetailList(PersonEnrollCourseParam param) {
        return new ResponseData((Object)this.trainingProviderServiceForUser.listPersnoEnrollCourse(param));
    }

    @GetMapping(value={"getTrainingWorkType"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType(Long uid) {
        return new ResponseData((Object)this.trainingProviderServiceForUser.getTrainingWorkType(uid));
    }

    @PostMapping(value={"upRedundencyInfo", "updateRedundancyExcludeUintInfo"})
    @RequiresPermissions(value={"training.sys.user.edit"})
    public ResponseData<String> updateRedundancyExcludeUintInfo(@RequestBody UpRedundancyInfoParam param) {
        this.tuEnrollProviderService.updateRedundancyExcludeUintInfo(param);
        return ResponseData.success();
    }

    @PostMapping(value={"updateUnitRedundancyInfo"})
    @RequiresPermissions(value={"training.sys.user.edit"})
    public ResponseData<String> updateUnitRedundancyInfo(@RequestBody UpRedundancyInfoParam param) {
        this.tuEnrollProviderService.updateUnitRedundancyInfo(param);
        return ResponseData.success();
    }
}

