/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.model.GeneralListParam;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceVirtuallyEnum;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.companyChange.v3.provider.ICompanyChangeV3ProviderService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3AddParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3EditParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3ListParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3ListVo;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.model.hse.ImportCompanyData;
import cn.smarthse.radiationTraining.modules.admin.service.easyexcel.SysCompanyUserImportAddListener;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollNumberVo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"/v3/sys/companyUser"})
public class SysCompanyUserV3Controller
extends ControllerSupport {
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;
    @DubboReference(registry={"public_nacos"})
    private IDcCompanyService dcCompanyService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private ISysUserThirdService sysUserThirdService;
    @DubboReference(registry={"public_nacos"})
    private ICompanyChangeV3ProviderService companyChangeV3ProviderService;

    @Log(type=LogTypeEnum.type_opt, title="\u5217\u8868")
    @RequiresPermissions(value={"training.sys.user.view"})
    @GetMapping(value={"getList"})
    public ResponseData<LayuiGridData<CompanyUserV3ListVo>> getList(CompanyUserV3ListParam param) {
        this.setSearchListParam(param);
        PageInfo pageInfo = this.dcCompanyService.getCompanyUserV3List(param);
        if (CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List cidList = pageInfo.getList().stream().map(CompanyUserV3ListVo::getId).collect(Collectors.toList());
            Map<Long, EnrollNumberVo> map = this.tuEnrollProviderService.getEnrollCount(cidList).stream().collect(Collectors.toMap(EnrollNumberVo::getToken, v -> v));
            for (CompanyUserV3ListVo dto : pageInfo.getList()) {
                EnrollNumberVo en = map.get(dto.getId());
                if (Objects.nonNull(en)) {
                    dto.setOnlineTrainUserId(en.getUserId());
                    dto.setNumber(Integer.valueOf(Objects.isNull(en.getNumber()) ? 0 : en.getNumber()));
                }
                if (dto.getIsRegulationVisible() == 1) {
                    dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.ZLWQ.getValue());
                    continue;
                }
                if (dto.getIsRegulationVisible() == 0 && Objects.equals(dto.getDataSource(), CompanyDataSourceEnum.OLINETRAIN.getValue())) {
                    dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.OLINETRAIN.getValue());
                    continue;
                }
                if (dto.getIsRegulationVisible() == 0 && Objects.equals(dto.getDataSource(), CompanyDataSourceEnum.NEW_COMPANY_GUIDE.getValue())) {
                    dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.NEW_COMPANY_GUIDE.getValue());
                    continue;
                }
                dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.OTHER2.getValue());
            }
        }
        return ResponseData.success((Object)new LayuiGridData(pageInfo));
    }

    private void setSearchListParam(CompanyUserV3ListParam param) {
        param.setSystemDeploymentSource(SystemDeploymentSourceEnum.ONLINE_TRAINING.getCode());
        param.setCount(Boolean.FALSE);
        param.setUserAreaId(ShiroUtil.getLoginAreaId());
        param.setUserAreaLevel(ShiroUtil.getLoginAreaLevel());
        Optional.ofNullable(param.getSearchAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaByIdV3(arg_0)).ifPresent(area -> param.setSearchAreaLevel(area.getLevel()));
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        if (Objects.equals(param.getIsNowUser(), Boolean.TRUE)) {
            param.setLoginUserId(ShiroUtil.getLoginUserId2());
        }
    }

    @RequiresPermissions(value={"training.sys.user.view"})
    @GetMapping(value={"getListCount"})
    public ResponseData<Long> getListCount(CompanyUserV3ListParam param) {
        this.setSearchListParam(param);
        return ResponseData.success((Object)this.dcCompanyService.getCompanyUserV3ListCount(param));
    }

    @Log(type=LogTypeEnum.type_opt_add, title="\u521b\u5efa\u8d26\u53f7")
    @ApiEncrypt(response=true)
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"createSysUser"})
    public ResponseData<?> createSysUser(@RequestBody GeneralListParam param) {
        return this.sysUserThirdService.createSysUser(param.getIdList(), ShiroUtil.getLoginUserId2()) != false ? ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)"Zyj@2022") : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_add, title="\u65b0\u589e\u4f01\u4e1a\u540c\u65f6\u521b\u5efa\u8d26\u53f7")
    @ApiEncrypt(response=true)
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"save"})
    public ResponseData<?> save(@RequestBody @Validated CompanyUserV3AddParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId2());
        return this.dcCompanyService.saveForTrain(param) != false ? ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)"Zyj@2022") : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_edit, title="\u66f4\u65b0\u4f01\u4e1a")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"updateResource"})
    public ResponseData<?> update(@RequestBody @Validated CompanyUserV3EditParam param) {
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setLoginUserId(ShiroUtil.getLoginUserId2());
        param.setUserName(ShiroUtil.getLoginUsername());
        return new ResponseData((Object)(this.dcCompanyService.updateForTrain(param) != false ? ResponseStateEnum.success : ResponseStateEnum.fail));
    }

    @Log(type=LogTypeEnum.type_opt_edit, title="\u8d26\u53f7\u72b6\u6001\u7981\u7528\u3001\u542f\u7528")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"enableOrDisable/{flag}"})
    public ResponseData<?> enableOrDisable(@RequestBody GeneralListParam param, @PathVariable Integer flag) {
        return new ResponseData((Object)(this.sysUserThirdService.disableOrEnableUserByCidList(param.getIdList(), flag, ShiroUtil.getLoginUserId2()) > 0 ? ResponseStateEnum.success : ResponseStateEnum.fail));
    }

    @Log(type=LogTypeEnum.type_opt_edit, title="\u8425\u4e1a\u72b6\u6001")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"changeBusinessState"})
    public ResponseData<?> changeBusinessState(Long id, Byte businessState) {
        return new ResponseData((Object)(this.dcCompanyService.changeBusinessState(id, businessState, ShiroUtil.getLoginUserId2()) != false ? ResponseStateEnum.success : ResponseStateEnum.fail));
    }

    @Log(type=LogTypeEnum.type_opt_reset)
    @ApiEncrypt(response=true)
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"resetPassword"})
    public ResponseData<?> resetPassword(Long userId) {
        return this.sysUserThirdService.resetPasswordByUserId(userId, "Zyj@2022", ShiroUtil.getLoginUserId2()) > 0 ? ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)"Zyj@2022") : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_del, title="\u5220\u9664\u5e76\u5220\u9664\u8d26\u53f7")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"delCompany"})
    public ResponseData<?> delCompany(@RequestBody GeneralListParam param) {
        return new ResponseData((Object)(this.dcCompanyService.delete(param.getIdList(), ShiroUtil.getLoginUserId2()) != false ? ResponseStateEnum.success : ResponseStateEnum.fail));
    }

    @Log(type=LogTypeEnum.type_opt_import, title="\u5bfc\u5165")
    @ApiEncrypt(response=true)
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"importData"})
    public ResponseData<String> importData(@RequestPart(value="file") MultipartFile file, Boolean isCreateUser) {
        try (InputStream inputStream = file.getInputStream();
             ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet().headRowNumber(Integer.valueOf(3))).head(ImportCompanyData.class)).registerReadListener((ReadListener)new SysCompanyUserImportAddListener(this.organizationService, this.companyProvideBySuperviseService, this.companyChangeV3ProviderService, this.industryProvideService, this.sysAreaProvideService, this.sysUserThirdService, ShiroUtil.getLoginUserId2(), isCreateUser))).build()});
        }
        catch (IOException e) {
            this.logger.error("\u7528\u4eba\u5355\u4f4d\u5bfc\u5165\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
        if (isCreateUser.booleanValue()) {
            return ResponseData.success((String)"\u5bfc\u5165\u6210\u529f\uff01", (Object)"Zyj@2022");
        }
        return ResponseData.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @Generated
    public SysCompanyUserV3Controller() {
    }
}

