/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.param;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysParam;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysParamVo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/param"})
public class SysParamController {
    @DubboReference
    private ISysParamProviderService sysParamProviderService;

    @GetMapping(value={"/getParamListData"})
    public ResponseData<LayuiGridData<SysParamVo>> getParamListData(ParamQueryParam param) {
        return new ResponseData((Object)this.sysParamProviderService.getParamListData(param));
    }

    @GetMapping(value={"/getParamList"})
    public ResponseData<List<SysParamVo>> getParamList(ParamQueryParam param) {
        return new ResponseData((Object)this.sysParamProviderService.getParamList(param));
    }

    @PostMapping(value={"/saveParam"})
    @RequiresPermissions(value={"sys:edit"})
    @Log(title="\u6570\u636e\u5b57\u5178-\u7f16\u8f91", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveParam(@RequestBody SaveSysParam param) {
        this.sysParamProviderService.saveParam(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"sys:edit"})
    @Log(title="\u6570\u636e\u5b57\u5178-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdsParam param) {
        this.sysParamProviderService.delParam(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/forbiddenParam"})
    @RequiresPermissions(value={"sys:edit"})
    @Log(title="\u6570\u636e\u5b57\u5178-\u505c\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenParam(@RequestBody ForbiddenParam param) {
        this.sysParamProviderService.forbiddenParam(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/searchByTypeAndKeyword"})
    public ResponseData<List<SysParam>> searchByTypeAndKeyword(String type, String keyword) {
        return new ResponseData((Object)this.sysParamProviderService.getByTypeAndKeyword(type, keyword));
    }
}

