/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.company;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.sys.param.sys.QueryFeedBackParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.QueryCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.SaveCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFeedbackProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.ICompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFeedBackVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.RhoCompanyListVo;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/company"})
public class SysCompanyController
extends ControllerSupport {
    @DubboReference
    private ICompanyProviderService companyProviderService;
    @DubboReference
    private ISysFeedbackProviderService sysFeedbackProviderService;

    @GetMapping(value={"getCompanyList"})
    @ResponseBody
    @RequiresPermissions(value={"sys:view"})
    public ResponseData<LayuiGridData<CompanyListVo>> getCompanyList(QueryCompanyParam param) {
        return new ResponseData((Object)this.companyProviderService.getCompanyList(param));
    }

    @GetMapping(value={"getFeedBackList"})
    @ResponseBody
    public ResponseData<LayuiGridData<SysFeedBackVo>> getFeedBackList(QueryFeedBackParam param) {
        return new ResponseData((Object)this.sysFeedbackProviderService.getFeedBackList(param));
    }

    @GetMapping(value={"getCompany"})
    @ResponseBody
    public ResponseData<CompanyVo> getCompany(Long id) {
        return new ResponseData((Object)this.companyProviderService.getCompany(id));
    }

    @PostMapping(value={"saveUser"})
    @ResponseBody
    @RequiresPermissions(value={"sys:user:crop:edit"})
    @Log(title="\u5355\u4f4d\u5e95\u5e93-\u7f16\u8f91", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveUser(@RequestBody SaveCompanyParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name", "creditCode", "areaId"});
        this.companyProviderService.saveUser(param);
        return ResponseData.success();
    }

    @GetMapping(value={"getCompanyListForRho"})
    @ResponseBody
    @RequiresPermissions(value={"sys:view"})
    public ResponseData<LayuiGridData<RhoCompanyListVo>> getCompanyListForRho(QueryCompanyParam param) {
        return new ResponseData((Object)this.companyProviderService.getCompanyListForRho(param));
    }
}

