/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.questionManage;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.service.easyexcel.QuestionImportListener;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSetBatchParam;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionData;
import cn.smarthse.radiationTraining.modules.question.provider.IQuestionProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.QuestionVo;
import cn.smarthse.radiationTraining.modules.question.vo.SpecialQuestionStatisticsVo;
import cn.smarthse.radiationTraining.modules.training.param.course.CoursePageParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseItemManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/questionManage"})
public class QuestionController
extends ControllerSupport {
    private final String info_prefix = "[\u8bd5\u9898\u7ba1\u7406]";
    @DubboReference
    private IQuestionProviderService questionProviderService;
    @DubboReference(check=false)
    private ICourseItemManagerProviderService courseItemManagerService;

    @RequiresPermissions(value={"training.testquestions.view"})
    @GetMapping(value={"getQuestionList"})
    public ResponseData<LayuiGridData<QuestionVo>> getUserList(QuestionSearchParam param) {
        param.setUid(ShiroUtil.getLoginUserId());
        param.setIsSpecifiedUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        return new ResponseData((Object)this.questionProviderService.getQuestionList(param));
    }

    @RequiresPermissions(value={"training.testquestions.view"})
    @GetMapping(value={"getQuestionDetail"})
    public ResponseData<QuestionVo> getQuestionDetail(Long questionId) {
        this.logger.debug("{}-\u67e5\u770b\u8bd5\u9898\u8be6\u60c5\uff1aquestionId-{}", (Object)"[\u8bd5\u9898\u7ba1\u7406]", (Object)questionId);
        return ResponseData.success((Object)this.questionProviderService.getQuestionDetailById(questionId));
    }

    @RequiresPermissions(value={"training.testquestions.edit"})
    @Log(title="\u65b0\u589e\u8bd5\u9898", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"/add"})
    @ResponseBody
    public ResponseData<String> add(@RequestBody QuestionVo question) {
        question.setCreateBy(ShiroUtil.getLoginUserId());
        question.setUpdateBy(ShiroUtil.getLoginUserId());
        question.setCreateName(ShiroUtil.getUserInfo().getUsername());
        question.setUpdateName(ShiroUtil.getUserInfo().getUsername());
        this.questionProviderService.addQuestion(question);
        return ResponseData.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"training.testquestions.edit"})
    @Log(title="\u66f4\u65b0\u8bd5\u9898", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResponseData<String> update(@RequestBody QuestionVo question) {
        question.setUpdateBy(ShiroUtil.getLoginUserId());
        question.setUpdateName(ShiroUtil.getUserInfo().getUsername());
        question.setIsSpecifiedUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        this.questionProviderService.updateQuestion(question);
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"training.testquestions.edit"})
    @PostMapping(value={"/setBatch"})
    @ResponseBody
    public ResponseData<String> setBatch(@RequestBody QuestionSetBatchParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIds())) {
            return ResponseData.fail((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        param.setUpdateBy(ShiroUtil.getLoginUserId());
        param.setUpdateName(ShiroUtil.getUserInfo().getUsername());
        param.setIsSpecifiedUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        this.logger.debug("{}-\u6279\u91cf\u8bbe\u7f6e \u5371\u5bb3\u56e0\u7d20\u3001\u884c\u4e1a\u3001\u8bfe\u7a0b\uff1aids-{}", (Object)"[\u8bd5\u9898\u7ba1\u7406]", (Object)param.getIds().size());
        this.questionProviderService.setBatch(param);
        return ResponseData.success((String)"\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"training.testquestions.edit"})
    @Log(title="\u5220\u9664\u8bd5\u9898", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"/del"})
    @ResponseBody
    public ResponseData<String> delete(@RequestBody IdsParam ids) {
        this.logger.debug("{}-\u5220\u9664\u3001\u6279\u91cf\u5220\u9664\uff1aids-{}", (Object)"[\u8bd5\u9898\u7ba1\u7406]", (Object)ids);
        ids.setUpdateBy(ShiroUtil.getLoginUserId());
        ids.setIsSpecifiedUser(ShiroUtil.isOnlineSpecialSuperAndTestUserWithZjs001());
        this.questionProviderService.deleteBatch(ids);
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"training.testquestions.view"})
    @GetMapping(value={"/courseChooseData"})
    public ResponseData<LayuiGridData<CourseItemVo>> searchItemsByKeyword(CoursePageParam param) {
        param.setStatus(Integer.valueOf(1));
        LayuiGridData layuiGridData = this.courseItemManagerService.searchItemsByKeyword(param);
        return new ResponseData((Object)layuiGridData);
    }

    @RequiresPermissions(value={"training.testquestions.edit"})
    @PostMapping(value={"/questionsImport"}, consumes={"multipart/form-data"})
    public ResponseData<String> questionsImport(@RequestPart(value="file") MultipartFile file) {
        this.logger.debug("{}-\u5355\u9009\u6279\u91cf\u5bfc\u5165", (Object)"[\u8bd5\u9898\u7ba1\u7406]");
        QuestionImportListener readListener = new QuestionImportListener(this.questionProviderService);
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ImportQuestionData.class, (ReadListener)readListener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (IOException e) {
            this.logger.error("IOException\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return new ResponseData("\u5bfc\u5165\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"training.testquestions.view"})
    @GetMapping(value={"/getSpecialQuestionNum"})
    public ResponseData<SpecialQuestionStatisticsVo> getSpecialQuestionNum(String code, Integer type) {
        return new ResponseData((Object)this.questionProviderService.getSpecialQuestionNum(code, type));
    }
}

