/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.questionManage;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.question.entity.PaperInstructions;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperInstructionsProviderService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/paperInstructions"})
public class PaperInstructionsController
extends ControllerSupport {
    @DubboReference
    private IPaperInstructionsProviderService paperInstructionsProviderService;

    @RequiresPermissions(value={"training.examnotice.view"})
    @GetMapping(value={"getInstruction"})
    public ResponseData<PaperInstructions> getAbout(Integer type) {
        if (type == null) {
            type = 0;
        }
        return new ResponseData((Object)this.paperInstructionsProviderService.getPaperInstructions(type, ShiroUtil.getLoginUserId()));
    }

    @RequiresPermissions(value={"training.examnotice.edit"})
    @PostMapping(value={"saveInstruction"})
    public ResponseData<String> saveAbout(@RequestBody PaperInstructions param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"id", "type", "content"});
        param.setUpdateBy(ShiroUtil.getLoginUserId());
        this.paperInstructionsProviderService.savePaperInstructions(param);
        return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

