/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.course;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import cn.smarthse.radiationTraining.modules.training.param.course.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.ClassHourStatisticsParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemEditFullInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemSingleOptParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.course.KeyCourseAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.MatchCourseParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseItemManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.ClassHourstatisticsVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/course/item"})
public class CourseItemController
extends ControllerSupport {
    @DubboReference(check=false)
    private ICourseItemManagerProviderService courseItemManagerService;

    @RequiresPermissions(value={"training.course.view"})
    @GetMapping(value={"/getPreciseCourseByTid"})
    public ResponseData<LayuiGridData<CourseItemVo>> getPreciseCourseByTid(CoursePageParam param) {
        LayuiGridData layuiGridData = this.courseItemManagerService.getPreciseCourseByTid(param);
        return new ResponseData((Object)layuiGridData);
    }

    @RequiresPermissions(value={"training.course.view"})
    @GetMapping(value={"/search"})
    public ResponseData<LayuiGridData<CourseItemVo>> searchItemsByKeyword(CoursePageParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        param.setLoginWide(this.getLoginWide());
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setReqSource(null);
        }
        LayuiGridData layuiGridData = this.courseItemManagerService.searchItemsByKeyword(param);
        return new ResponseData((Object)layuiGridData);
    }

    private Integer getLoginWide() {
        Set<Integer> list = ShiroUtil.getLoginUserSystemWideList();
        Integer wide = null;
        if (CollUtil.contains(list, (Object)0)) {
            wide = 0;
        }
        if (CollUtil.contains(list, (Object)0) && CollUtil.contains(list, (Object)1)) {
            wide = 1;
        }
        if (CollUtil.contains(list, (Object)0) && CollUtil.contains(list, (Object)1) && CollUtil.contains(list, (Object)2)) {
            wide = 2;
        }
        return wide;
    }

    @RequiresPermissions(value={"training.course.view"})
    @GetMapping(value={"/search/training"})
    public ResponseData<LayuiGridData<CourseItemVo>> searchItemsByKeywordForEditingTraining(CoursePageParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setReqSource(null);
        }
        LayuiGridData layuiGridData = this.courseItemManagerService.searchItemsByKeyword(param);
        return new ResponseData((Object)layuiGridData);
    }

    @RequiresPermissions(value={"training.course.view"})
    @GetMapping(value={"/countClassHours"})
    public ResponseData<ClassHourstatisticsVo> countClassHours(ClassHourStatisticsParam param) {
        return ResponseData.success((Object)this.courseItemManagerService.countClassHoursV1(param));
    }

    @RequiresPermissions(value={"training.course.view"})
    @GetMapping(value={"/countClassHours/v3221"})
    public ResponseData<List<ClassHourstatisticsVo>> countClassHoursV3_2_2_1(ClassHourStatisticsParam param) {
        return ResponseData.success((Object)this.courseItemManagerService.countClassHoursV3_2_2_1(param));
    }

    @RequiresPermissions(value={"training.course.edit"})
    @Log(title="\u8bfe\u7a0b-\u6dfb\u52a0", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"/add"})
    public ResponseData add(@RequestBody CourseItemAddParam param) {
        this.courseItemManagerService.addCourseItem(param);
        return ResponseData.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @RequiresPermissions(value={"training.course.edit"})
    @Log(title="\u8bfe\u7a0b-\u6dfb\u52a0\u91cd\u70b9\u8bfe\u7a0b\u8349\u7a3f", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"/addKeyCourse"})
    public ResponseData addKeyCourse(@RequestBody KeyCourseAddParam param) {
        this.courseItemManagerService.addKeyCourse(param);
        return ResponseData.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @RequiresPermissions(value={"training.course.view"}, logical=Logical.OR)
    @GetMapping(value={"/detail"})
    public ResponseData<CourseItemVo> detail(Long courseItemId, Boolean ifIncludeQuestNum) {
        CourseItemVo courseItemVo = this.courseItemManagerService.getCourseItemById(courseItemId);
        if (ifIncludeQuestNum == null || ifIncludeQuestNum.booleanValue()) {
            // empty if block
        }
        return new ResponseData((Object)courseItemVo);
    }

    @RequiresPermissions(value={"training.course.edit"})
    @Log(title="\u8bfe\u7a0b-\u7f16\u8f91-\u4e00\u6b21\u6027\u7f16\u8f91\u8bfe", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/editFullInfo"})
    public ResponseData editFullInfo(@RequestBody CourseItemEditFullInfoParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkParam = new CheckEditPermissionParam().setUid(userInfo.getId()).setUname(userInfo.getUsername()).setAreaId(userInfo.getAreaId()).setItemId(param.getId());
        this.courseItemManagerService.checkOneEditPermission(checkParam);
        this.courseItemManagerService.editFullCourseItemInfo(param);
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequiresPermissions(value={"training.course.edit"})
    @Log(title="\u8bfe\u7a0b-\u5220\u9664", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"/edit/delete"})
    public ResponseData delete(@RequestBody IdParam idParam) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkParam = new CheckEditPermissionParam().setUid(userInfo.getId()).setUname(userInfo.getUsername()).setAreaId(userInfo.getAreaId()).setItemId(idParam.getId());
        this.courseItemManagerService.checkOneEditPermission(checkParam);
        this.courseItemManagerService.delete(idParam.getId());
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequiresPermissions(value={"training.course.edit"})
    @Log(title="\u8bfe\u7a0b-\u6279\u91cf\u7ba1\u7406\uff081\uff1a\u542f\u7528\u30012\uff1a\u7981\u7528\u30013\uff1a\u5220\u9664\uff09", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt)
    @PostMapping(value={"/edit/batchOpt"})
    public ResponseData batchOpt(@RequestBody List<CourseItemSingleOptParam> paramList) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkParam = new CheckEditPermissionParam().setUid(userInfo.getId()).setAreaId(userInfo.getAreaId()).setUname(userInfo.getUsername()).setItemIdList(paramList.stream().map(CourseItemSingleOptParam::getCourseItemId).collect(Collectors.toList()));
        this.courseItemManagerService.checkBatchEditPermission(checkParam);
        List courseItemBatchOptVoList = this.courseItemManagerService.batchOpt(paramList);
        if (CollUtil.isNotEmpty((Collection)courseItemBatchOptVoList)) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u63d0\u793a\u8fdb\u884c\u4fee\u6539", (Object)courseItemBatchOptVoList);
        }
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training.course.edit"})
    @PostMapping(value={"/test"})
    public ResponseData<List<CourseItemVo>> test(@RequestBody MatchCourseParam param) {
        return new ResponseData((Object)this.courseItemManagerService.matchCourse(param));
    }
}

