/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.certificate;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.service.easyexcel.RaTrainCertImportListener;
import cn.smarthse.radiationTraining.modules.training.dto.ImportRaTuCertDto;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.training.RaTraining;
import cn.smarthse.radiationTraining.modules.training.param.course.SyncRaCertParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateEditParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.IRaTrainingProviderService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/raTuCertificate"})
public class RaTrainingController
extends ControllerSupport {
    private final String info_prefix = "[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]";
    @DubboReference
    private IRaTrainingProviderService raTrainingProviderService;

    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<RaTraining>> getTrainingList(RaTuCertificateParam param) {
        this.logger.debug("{}-\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u5217\u8868", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        if (param.getAreaId() == null) {
            param.setAreaId(ShiroUtil.getLoginAreaId());
        }
        return new ResponseData((Object)this.raTrainingProviderService.getTrainingList(param));
    }

    @GetMapping(value={"getTrainingById"})
    public ResponseData<RaTraining> getTrainingById(IdParam param) {
        this.logger.debug("{}-\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u4fe1\u606f\u67e5\u8be2", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        return new ResponseData((Object)this.raTrainingProviderService.getTrainingById(param.getId()));
    }

    @PostMapping(value={"/addTraining"})
    @ResponseBody
    public ResponseData<RaTraining> addTraining(@RequestBody RaTraining param) {
        this.logger.debug("{}-\u65b0\u589e\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u57fa\u7840\u4fe1\u606f", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        RaTraining training = this.raTrainingProviderService.addRaTraining(param);
        return ResponseData.success((Object)training);
    }

    @PostMapping(value={"/delTraining"})
    @ResponseBody
    public ResponseData<String> delTraining(@RequestBody IdParam param) {
        this.logger.debug("{}-\u5220\u9664\u57f9\u8bad\u8bb0\u5f55", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        this.raTrainingProviderService.delTraining(param.getId());
        return ResponseData.success();
    }

    @PostMapping(value={"/submit"})
    @ResponseBody
    public ResponseData<String> submit(@RequestBody RaTuCertificateParam param) {
        this.logger.debug("{}-\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c\u6570\u636e\u63d0\u4ea4", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        this.raTrainingProviderService.submit(param);
        return ResponseData.success();
    }

    @GetMapping(value={"getCertList"})
    public ResponseData<LayuiGridData<RaTuCertificate>> getCertList(RaTuCertificateParam param) {
        this.logger.debug("{}-\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c\u6570\u636e\u5217\u8868", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        return new ResponseData((Object)this.raTrainingProviderService.getCertList(param));
    }

    @GetMapping(value={"getCertDetail"})
    @ApiEncrypt(response=true)
    public ResponseData<RaTuCertificate> getCertDetail(Long id) {
        this.logger.debug("{}-\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad-\u4eba\u5458\u57f9\u8bad\u8be6\u60c5", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        return new ResponseData((Object)this.raTrainingProviderService.getCertDetail(id));
    }

    @PostMapping(value={"/saveCertDetail"})
    @ApiEncrypt(request=true)
    @ResponseBody
    public ResponseData<String> saveCertDetail(@RequestBody RaTuCertificateEditParam param) {
        this.logger.debug("{}-\u7f16\u8f91\u4fdd\u5b58\u4eba\u5458\u57f9\u8bad\u8be6\u60c5\u6570\u636e", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        this.raTrainingProviderService.saveCertDetail(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/clearCertData"})
    @ResponseBody
    public ResponseData<String> clearCertData(@RequestBody RaTuCertificateParam param) {
        this.logger.debug("{}-\u6e05\u7a7a\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c\u6570\u636e", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        this.raTrainingProviderService.clearCertData(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/syncCert"})
    @ResponseBody
    public ResponseData<String> syncCert(@RequestBody SyncRaCertParam param) {
        this.logger.debug("{}-\u540c\u6b65\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c\u6570\u636e", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]");
        this.raTrainingProviderService.syncCertData(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/importCertData"})
    public ResponseData<String> importCertData(@RequestPart(value="file") MultipartFile file, Long tid) {
        InputStream inputStream;
        this.logger.debug("{}-\u57f9\u8bad\u7ed3\u679c\u5bfc\u5165[tid-{}]", (Object)"[\u653e\u5c04\u4e13\u59d4\u4f1a\u57f9\u8bad\u7ed3\u679c]", (Object)tid);
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            this.logger.error("IOException\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
        RaTrainCertImportListener readListener = new RaTrainCertImportListener(tid, this.raTrainingProviderService);
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream, ImportRaTuCertDto.class, (ReadListener)readListener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        return ResponseData.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }
}

