/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.api;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.param.sys.CheckAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.QueryAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysAppVersionProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CheckAppVersionVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysAppVersionVo;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/app"})
public class AppVersionController
extends ControllerSupport {
    @DubboReference
    private ISysAppVersionProviderService sysAppVersionProviderService;

    @GetMapping(value={"search"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1)
    public ResponseData<LayuiGridData<SysAppVersionVo>> search(QueryAppVersionParam param) {
        return new ResponseData((Object)this.sysAppVersionProviderService.search(param));
    }

    @PostMapping(value={"check"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1)
    public ResponseData<CheckAppVersionVo> checkUserAppVersion(@RequestBody CheckAppVersionParam param) {
        return ResponseData.success((Object)this.sysAppVersionProviderService.checkUserAppVersion(param));
    }

    @GetMapping(value={"current"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1)
    public ResponseData<SysAppVersionVo> getCurrent(String version, Integer type) {
        return ResponseData.success((Object)this.sysAppVersionProviderService.getCurrVersion(version, type));
    }

    @GetMapping(value={"newest/forced"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1)
    public ResponseData<SysAppVersionVo> getNewestOfForcedUpdatingVersion(Integer type) {
        return new ResponseData((Object)this.sysAppVersionProviderService.getNewestOfForcedUpdatingVersion(type));
    }

    @GetMapping(value={"newest"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1)
    public ResponseData<SysAppVersionVo> getNewest(Integer type) {
        return new ResponseData((Object)this.sysAppVersionProviderService.getNewest(type));
    }
}

