/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller;

import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysPermissionV3Service;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.AesUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.LoginData;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference(registry={"public_nacos"})
    private ISysPermissionV3Service sysPermissionV3Service;

    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module7)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u6d59\u91cc\u536b\u4f01\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef")
    @PostMapping(value={"/cas"})
    public ResponseData<LoginData> loginByCas(String sign) {
        String decrypt = AesUtil.decrypt((String)sign);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        Long time = (Long)jsonObject.getObject("time", Long.class, new JSONReader.Feature[0]);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class, new JSONReader.Feature[0]);
        String token = (String)jsonObject.getObject("token", String.class, new JSONReader.Feature[0]);
        String username = (String)jsonObject.getObject("username", String.class, new JSONReader.Feature[0]);
        long expreTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        CasToken casToken = new CasToken(username, token);
        LoginData result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @GetMapping(value={"/getRouters"})
    public ResponseData<List<Tree<Long>>> getRouters() {
        return ResponseData.success((Object)this.sysPermissionV3Service.getRouters(UserSystemWideEnum.OLINETRAIN.getCode(), ShiroUtil.getLoginUserId2()));
    }

    @Generated
    public LoginController(LoginService loginService) {
        this.loginService = loginService;
    }
}

