/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import java.util.Objects;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        Subject subject = ShiroUtil.getSubject();
        return (ShiroPrincipal)subject.getPrincipal();
    }

    public static ShiroPrincipal getShiroPrincipalDesensitization(ShiroPrincipal principal) {
        ShiroPrincipal principalDesensitization = (ShiroPrincipal)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)principal), ShiroPrincipal.class);
        principal.getUser().setUsername(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getUsername(), (DesensitizationType)DesensitizationType.NAME));
        principal.getUser().setPhone(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getPhone(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        principal.getUser().setPassword(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getPassword(), (DesensitizationType)DesensitizationType.PASSWORD));
        principal.getUser().setName(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getName(), (DesensitizationType)DesensitizationType.NAME));
        return principalDesensitization;
    }

    public static UserInfo getUserInfo() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            return principal.getUser();
        }
        return null;
    }

    public static Long getLoginUserId() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getId() : null;
    }

    public static Long getLoginUserId2() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? Long.valueOf(user.getToken()) : null;
    }

    public static Long getOid() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getOid() : null;
    }

    public static String getLoginUsername() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginUserNickname() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getName() : null;
    }

    public static Long getLoginAreaId() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getAreaId() : null;
    }

    public static Byte getLoginAreaLevel() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getLevel() : null;
    }

    public static Set<Integer> getLoginUserSystemWideList() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getSystemWideList() : CollUtil.newHashSet((Object[])new Integer[0]);
    }

    public static Set<String> getPermissionSet() {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet();
    }

    public static Set<String> getRoleSet() {
        return ShiroUtil.getShiroPrincipal().getRoleSet();
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getPermissionSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getRoleSet().contains(roleCode);
    }

    public static Boolean isOnlineSpecialSuperAndTestUser() {
        UserInfo user = ShiroUtil.getUserInfo();
        String loginUserName = user.getUsername();
        return "superuser".equalsIgnoreCase(loginUserName) || Objects.equals(user.getIsTest(), 1);
    }

    public static Boolean isOnlineSpecialSuperAndTestUserWithZjs001() {
        UserInfo user = ShiroUtil.getUserInfo();
        String loginUserName = user.getUsername();
        return StrUtil.equalsAnyIgnoreCase((CharSequence)loginUserName, (CharSequence[])new CharSequence[]{"superuser", "zjs001", "zjs200"}) || Objects.equals(user.getIsTest(), 1);
    }

    public static String getTrainingVersion() {
        return ((SysProperties)SpringUtils.getBean(SysProperties.class)).getTrainingVersion();
    }
}

