/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogResourceEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.sys.entity.SysLog;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ILogProviderService;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Aspect
@Component
@Order(value=1)
public class SysLogAopAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLogAopAspect.class);
    @DubboReference
    private ILogProviderService logProviderService;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Pointcut(value="@annotation(cn.smarthse.radiationTraining.core.framework.annotation.Log)")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
    }

    @Around(value="pointCut()")
    public Object aroundLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        return result;
    }

    @AfterReturning(value="pointCut()")
    public void afterReturning(JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Log log = method.getAnnotation(Log.class);
        if (log != null) {
            ShiroPrincipal principal = (ShiroPrincipal)SecurityUtils.getSubject().getPrincipal();
            if (principal == null) {
                return;
            }
            HttpServletRequest request = ServletUtils.getRequest();
            SysLog syslog = new SysLog();
            syslog.setUserId(principal.getUser().getId());
            syslog.setUsername(principal.getUser().getUsername());
            syslog.setFullname(principal.getUser().getName());
            syslog.setTitle(log.title());
            syslog.setAreaId(principal.getUser().getAreaId());
            syslog.setResource(LogResourceEnum.ADMIN.getValue());
            syslog.setType(log.type().value);
            syslog.setModuleType(log.logModule().moduleType);
            this.setParams(request, syslog);
            syslog.setRequestMethod(request.getMethod());
            syslog.setRemoteIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            syslog.setRequestUri(ServletUtils.getRequestUri((HttpServletRequest)request));
            syslog.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)request));
            syslog.setCreateBy(principal.getUser().getId());
            syslog.setUpdateBy(principal.getUser().getId());
            this.threadPoolTaskExecutor.execute(() -> this.logProviderService.addLog(syslog));
        }
    }

    private void setParams(HttpServletRequest request, SysLog syslog) {
        if (syslog.getType().equals(LogTypeEnum.type_login.value) || request instanceof StandardMultipartHttpServletRequest) {
            return;
        }
        Map parameterMap = request.getParameterMap();
        syslog.setParams(StringUtils.substring((String)(CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : ServletUtils.getBody((ServletRequest)request)), (int)0, (int)255));
    }

    private boolean isCommonParam(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof MultipartFile) && !(arg instanceof HttpServletResponse) && !(arg instanceof HttpServletRequest)) continue;
            return false;
        }
        return true;
    }

    private void printParam(Object[] args, String url) {
        if (!this.isCommonParam(args)) {
            return;
        }
        if (url.contains("/login")) {
            return;
        }
        log.info("\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}", (Object)JSON.toJSONString((Object)args));
    }
}

