/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.service.order.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.AlipayProperties;
import cn.smarthse.radiationTraining.modules.admin.service.order.IPayService;
import cn.smarthse.radiationTraining.modules.admin.service.order.right.OrderRefundRightRecoverFactory;
import cn.smarthse.radiationTraining.modules.sys.dto.order.OrderRefundContext;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderLog;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderRefund;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderLogTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderRefundStateEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderThirdPayTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.order.OrderRefundParam;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderLogService;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderRefundService;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderService;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeRefundApplyModel;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements IPayService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AlipayProperties options;
    protected final StringRedisTemplate redisTemplate;
    private final OrderRefundRightRecoverFactory rightRecoverFactory;
    @DubboReference
    private ISysOrderService sysOrderService;
    @DubboReference
    private ISysOrderLogService sysOrderLogService;
    @DubboReference
    private ISysOrderRefundService sysOrderRefundService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;

    @Override
    public boolean refunds_alipay_admin(OrderRefundContext context) {
        this.logger.info("\u652f\u4ed8\u5b9d\u652f\u4ed8-\u9000\u6b3e-\u8ba2\u5355:{}-\u5f00\u59cb\u9000\u6b3e", (Object)context.getOrder().getId());
        Long tradeNo = context.getOrder().getId();
        Long orderRefundId = context.getOrderRefund().getId();
        BigDecimal refundAmount = context.getOrderRefund().getRefundAmount();
        String refundReason = "\u5546\u5bb6\u540c\u610f\u9000\u6b3e";
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.options.getGatewayHost(), this.options.appId, this.options.merchantPrivateKey, "json", "UTF-8", this.options.alipayPublicKey, this.options.signType);
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        AlipayTradeRefundApplyModel model = new AlipayTradeRefundApplyModel();
        model.setOutTradeNo(tradeNo.toString());
        model.setRefundAmount(refundAmount.toString());
        model.setRefundReason(refundReason);
        request.setBizModel((AlipayObject)model);
        AlipayTradeRefundResponse response = null;
        try {
            response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                String outTradeNo = response.getOutTradeNo();
                String refundFee = response.getRefundFee();
                this.logger.info("\u652f\u4ed8\u5b9d\u652f\u4ed8-\u9000\u6b3e-\u6210\u529f-outTradeNo:{}-refundFee:{}", (Object)outTradeNo, (Object)refundFee);
                return true;
            }
            this.logger.info("\u652f\u4ed8\u5b9d\u652f\u4ed8-\u9000\u6b3e-\u5931\u8d25-subMsg:{}", (Object)response.getSubMsg());
            return false;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void refundPassByAdmin(OrderRefundParam param) {
        SysOrderRefund sysOrderRefund = (SysOrderRefund)this.sysOrderRefundService.getById((Serializable)param.getOrderRefundId());
        if (sysOrderRefund == null) {
            throw new ServiceException("\u9000\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        SysOrder sysOrder = (SysOrder)this.sysOrderService.getById((Serializable)sysOrderRefund.getOrderId());
        if (sysOrder == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (!OrderPayStateEnum.APPLY_REFUND.getValue().equals(sysOrder.getPayState())) {
            throw new ServiceException("\u76ee\u524d\u53ea\u6709\u201c\u7533\u8bf7\u9000\u6b3e\u201d\u72b6\u6001\u7684\u8ba2\u5355\u624d\u80fd\u9000\u6b3e\uff01");
        }
        TuEnrollDetail enrollDetail = this.enrollProviderService.getEnrollDetailById(sysOrder.getBusinessId());
        if (enrollDetail != null && Objects.equals(enrollDetail.getHasBegunTest(), Constant.YES)) {
            throw new ServiceException("\u7528\u6237\u5df2\u5f00\u59cb\u8003\u8bd5\uff0c\u4e0d\u4e88\u9000\u6b3e\uff01");
        }
        OrderRefundContext orderRefundContext = new OrderRefundContext();
        orderRefundContext.setOrder(sysOrder);
        orderRefundContext.setOrderRefund(sysOrderRefund);
        boolean refundState = false;
        if (OrderThirdPayTypeEnum.ALIPAY.getValue().equals(sysOrder.getThirdPayType())) {
            refundState = this.refunds_alipay_admin(orderRefundContext);
        }
        if (!refundState) {
            throw new ServiceException("\u9000\u6b3e\u5931\u8d25\uff01");
        }
        sysOrder.setPayState(OrderPayStateEnum.REFUND.getValue());
        this.sysOrderService.updateById((Object)sysOrder);
        this.sysOrderRefundService.saveSuccessOrderRefund(param);
        this.sysOrderLogService.addOrderLog(new SysOrderLog(sysOrder.getId(), OrderLogTypeEnum.REFUND_SUCCESS.getValue(), OrderLogTypeEnum.REFUND_SUCCESS.getName(), param.getLoginUserId(), param.getLoginUsername(), new Date(), param.getRemark()));
        this.enrollProviderService.changePayStateAfterOrderChange(sysOrder.getBusinessId());
    }

    public void refundFailByAdmin(OrderRefundParam param) {
        SysOrderRefund sysOrderRefund = (SysOrderRefund)this.sysOrderRefundService.getById((Serializable)param.getOrderRefundId());
        if (sysOrderRefund == null) {
            throw new ServiceException("\u9000\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        SysOrder sysOrder = (SysOrder)this.sysOrderService.getById((Serializable)sysOrderRefund.getOrderId());
        if (sysOrder == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        this.sysOrderRefundService.saveFailOrderRefund(param);
        sysOrder.setPayState(OrderPayStateEnum.FAIL_REFUND.getValue());
        this.sysOrderService.updateById((Object)sysOrder);
        this.sysOrderLogService.addOrderLog(new SysOrderLog(sysOrder.getId(), OrderLogTypeEnum.REFUND_FAIL.getValue(), OrderLogTypeEnum.REFUND_FAIL.getName(), param.getLoginUserId(), param.getLoginUsername(), new Date(), param.getRemark()));
    }

    @Override
    public void refundAudit(OrderRefundParam param) {
        if (param.getOrderRefundId() == null || param.getAuditType() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        if (param.getAuditType().equals(OrderRefundStateEnum.SUCCESS_REFUND.getValue())) {
            param.setRemark("\u5546\u5bb6\u540c\u610f\u9000\u6b3e");
            this.refundPassByAdmin(param);
        } else {
            param.setRemark("\u5546\u5bb6\u62d2\u7edd\u9000\u6b3e");
            this.refundFailByAdmin(param);
        }
    }

    @Generated
    public PayServiceImpl(AlipayProperties options, StringRedisTemplate redisTemplate, OrderRefundRightRecoverFactory rightRecoverFactory) {
        this.options = options;
        this.redisTemplate = redisTemplate;
        this.rightRecoverFactory = rightRecoverFactory;
    }
}

