/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.service.easyexcel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.easyExcel.ExcelUtils;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.enums.sys.OrganizationTypeEnum;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.modules.admin.model.hse.ImportCompanyData;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysCompanyUserImportAddListener
extends AnalysisEventListener<ImportCompanyData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysCompanyUserImportAddListener.class);
    private static final int BATCH_COUNT = 3000;
    private final Long loginUserId;
    private final Boolean isCreateUser;
    private final IOrganizationService organizationService;
    private final ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    private final IndustryProvideService industryProvideService;
    private final ISysAreaProvideService sysAreaProvideService;
    private final ISysUserThirdService sysUserThirdService;
    private final List<ImportCompanyData> dataList = new ArrayList<ImportCompanyData>();
    private final List<ImportCompanyData> errDataList = new ArrayList<ImportCompanyData>();
    private final List<Long> idList = new ArrayList<Long>();
    private int dataCount = 0;
    private int rowIndex = 4;

    public SysCompanyUserImportAddListener(IOrganizationService organizationService, ICompanyProvideBySuperviseService companyProvideBySuperviseService, IndustryProvideService industryProvideService, ISysAreaProvideService sysAreaProvideService, ISysUserThirdService sysUserThirdService, Long loginUserId, Boolean isCreateUser) {
        this.organizationService = organizationService;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.industryProvideService = industryProvideService;
        this.sysAreaProvideService = sysAreaProvideService;
        this.sysUserThirdService = sysUserThirdService;
        this.loginUserId = loginUserId;
        this.isCreateUser = isCreateUser;
    }

    public void invoke(ImportCompanyData dto, AnalysisContext context) {
        log.debug("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)dto);
        if (StrUtil.isBlank((CharSequence)dto.getName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)1)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getUnifiedSocialCc())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)2)));
        } else if (dto.getUnifiedSocialCc().length() != 18) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", ExcelUtils.getExcelColName((int)2)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getDetailAreaName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)3)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getBelongTypeName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u662f\u5426\uff08\u7701/\u5e02\uff09\u76f4\u7ba1\u4f01\u4e1a\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)4)));
        } else {
            Integer valueByName = CompanyBelongTypeEnum.getValueByName((String)dto.getBelongTypeName());
            if (Objects.isNull(valueByName)) {
                dto.setHaveError(Boolean.TRUE);
                dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u76f4\u5c5e\u4f01\u4e1a\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01", ExcelUtils.getExcelColName((int)4)));
            }
        }
        if (StrUtil.isBlank((CharSequence)dto.getIndustryCategoryName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5c5e\u884c\u4e1a\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)5)));
        }
        dto.setId(IdWorker.getId());
        dto.setRowIndex(this.rowIndex);
        ++this.rowIndex;
        ++this.dataCount;
        if (Boolean.TRUE.equals(dto.getHaveError())) {
            this.errDataList.add(dto);
        } else {
            this.dataList.add(dto);
        }
        if (this.dataCount >= 3000) {
            this.saveData();
            this.dataList.clear();
            this.dataCount = 0;
        }
    }

    private AreaModel getAreaModelFromMap(Map<String, AreaModel> areaNameMap, String areaName) {
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            areaName = StringUtils.replace((String)areaName, (String)"\u300b", (String)"");
            areaName = StringUtils.replace((String)areaName, (String)">", (String)"");
            areaName = StringUtils.replace((String)areaName, (String)"\uff1e", (String)"");
            return areaNameMap.get(areaName);
        }
        return null;
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.debug("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
        this.saveData();
    }

    private void saveData() {
        if (CollUtil.isEmpty(this.errDataList) && CollUtil.isEmpty(this.dataList)) {
            ImportCompanyData dto = new ImportCompanyData();
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            this.errDataList.add(dto);
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
        }
        if (CollUtil.isNotEmpty(this.errDataList)) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
        }
        log.debug("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.dataList.size());
        try {
            if (CollUtil.isNotEmpty(this.dataList)) {
                Set companyNameSet = this.dataList.stream().map(ImportCompanyData::getName).collect(Collectors.toSet());
                if (companyNameSet.size() < this.dataList.size()) {
                    ImportCompanyData dto = new ImportCompanyData();
                    dto.setHaveError(Boolean.TRUE);
                    dto.setErrorReason("Excel\u5217\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u4f01\u4e1a\u540d\u79f0");
                    this.errDataList.add(dto);
                    throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
                }
                List nameModelList = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByNameExcludeDelete(new ArrayList(companyNameSet));
                Map<String, CompanySuperviseModel> nameModelMap = nameModelList.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getName, item -> item, (v1, v2) -> v1));
                Map areaNameMap = this.sysAreaProvideService.getAreaNameMap();
                List industryList = this.industryProvideService.getIndustryList();
                Map<String, Long> industryMap = industryList.stream().collect(Collectors.toMap(IndustryModel::getName, IndustryModel::getId, (v1, v2) -> v1));
                ArrayList<CompanySuperviseModel> finalDataList = new ArrayList<CompanySuperviseModel>(this.dataList.size());
                ArrayList<CreateUserModel> createUserModeList = new ArrayList<CreateUserModel>(this.dataList.size());
                for (ImportCompanyData dto : this.dataList) {
                    AreaModel areaModel;
                    if (Objects.nonNull(nameModelMap.get(dto.getName()))) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u82e5\u65e0\u6cd5\u67e5\u8be2\u5230\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u786e\u8ba4\uff01", ExcelUtils.getExcelColName((int)1)));
                    }
                    if (Objects.isNull(areaModel = this.getAreaModelFromMap(areaNameMap, dto.getDetailAreaName()))) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u5185\u5bb9\u4e0d\u6b63\u786e\u6216\u4e0d\u5b8c\u6574\uff01", ExcelUtils.getExcelColName((int)3)));
                    } else if (areaModel.getLevel() < 4) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b\uff01", ExcelUtils.getExcelColName((int)3)));
                    } else {
                        dto.setDetailAreaId(areaModel.getId());
                        Long areaId = Objects.equals(dto.getBelongTypeName(), CompanyBelongTypeEnum.SHI.getName()) ? areaModel.getCityId() : (Objects.equals(dto.getBelongTypeName(), CompanyBelongTypeEnum.SHENG.getName()) ? areaModel.getProvinceId() : areaModel.getAreaId());
                        dto.setSupervisionAreaId(areaId);
                    }
                    if (StrUtil.isNotBlank((CharSequence)dto.getIndustryCategoryName()) && !industryMap.containsKey(dto.getIndustryCategoryName())) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5c5e\u884c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01", ExcelUtils.getExcelColName((int)5)));
                    } else {
                        dto.setIndustryCategory(industryMap.get(dto.getIndustryCategoryName()));
                    }
                    if (Boolean.TRUE.equals(dto.getHaveError())) {
                        this.errDataList.add(dto);
                        continue;
                    }
                    CompanySuperviseModel model = new CompanySuperviseModel();
                    model.setId(dto.getId());
                    model.setName(dto.getName());
                    model.setUnifiedSocialCc(dto.getUnifiedSocialCc());
                    model.setAreaDetailId(dto.getDetailAreaId());
                    model.setIndustryCategory(dto.getIndustryCategory());
                    model.setDataSource(CompanyDataSourceEnum.OLINETRAIN.getValue());
                    model.setBelongType(CompanyBelongTypeEnum.getValueByName((String)dto.getBelongTypeName()));
                    model.setSupervisionAreaId(dto.getSupervisionAreaId());
                    finalDataList.add(model);
                    if (Objects.equals(this.isCreateUser, Boolean.TRUE)) {
                        CreateUserModel createUserModel = new CreateUserModel();
                        createUserModel.setCid(model.getId());
                        createUserModel.setUsername(model.getName());
                        createUserModel.setPassword("Zyj@2022");
                        createUserModel.setCreateBy(this.loginUserId);
                        createUserModeList.add(createUserModel);
                    }
                    this.idList.add(model.getId());
                }
                if (CollUtil.isNotEmpty(this.errDataList)) {
                    throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
                }
                Map orgMapByIdListMap = this.organizationService.getOrganizationByAreaIdList(finalDataList.stream().map(CompanyBaseInfoModel::getSupervisionAreaId).collect(Collectors.toSet()), OrganizationTypeEnum.HEALTH_CONSTRUCTION_SYSTEM.getValue());
                Organization protoOrg = new Organization();
                finalDataList.stream().peek(i -> {
                    Organization orDefault = orgMapByIdListMap.getOrDefault(i.getSupervisionAreaId(), protoOrg);
                    i.setSupervisionUnit(orDefault.getId());
                    i.setSupervisionAreaId(orDefault.getAreaId());
                }).collect(Collectors.toList());
                this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByList(finalDataList, this.loginUserId);
                this.sysUserThirdService.create(createUserModeList);
            }
        }
        catch (Exception e) {
            this.companyProvideBySuperviseService.rollbackImportCompanyAndCompanySuperviseData(this.idList);
            if (Objects.equals(this.isCreateUser, Boolean.TRUE)) {
                this.sysUserThirdService.rollbackImportUserData(this.idList);
            }
            throw e;
        }
        log.debug("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }
}

