/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.training;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.Certificate;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingChangeRecord;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToRemoveStaffParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToRmCropEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToSendBackCropParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToSendBackParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.ResurgenceEnrollDataParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TidParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainEnrollDetailOptBatchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainEnrollOptBatchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingAddParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingDelParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingEnrollDetailSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingStatusUpdateParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingUpdateParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ICertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingUnitEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=10, author="\u891a\u6d77\u6d0b")
@Api(tags={"\u57f9\u8bad\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/trainingManage/train"})
public class TrainingController
extends ControllerSupport {
    @DubboReference
    private ITrainingProviderService iTrainingProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private ICertificateProviderService certificateProviderService;

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u7ba1\u7406\u5217\u8868")
    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getTrainingList(TrainingSearchParam param) {
        param.setAreaId(ShiroUtil.getUserInfo().getAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        param.setAreaId(ShiroUtil.getLoginAreaId());
        Set<Integer> wideSet = ShiroUtil.getLoginUserSystemWideList();
        if (wideSet.contains(0) && wideSet.contains(1)) {
            param.setSupFrom(Integer.valueOf(3));
        } else if (wideSet.contains(0)) {
            param.setSupFrom(Integer.valueOf(0));
        } else if (wideSet.contains(1)) {
            param.setSupFrom(Integer.valueOf(1));
        }
        return new ResponseData((Object)this.iTrainingProviderService.getTrainingList(param));
    }

    @ApiOperationSupport(order=5)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u8be6\u60c5(\u57fa\u672c\u4fe1\u606f\u3001\u8003\u8bd5\u4fe1\u606f)")
    @GetMapping(value={"getTrainingDetail"})
    public ResponseData<TrainingDetailVo> getTrainingDetail(TrainingSearchParam param) {
        param.setAreaId(ShiroUtil.getUserInfo().getAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return ResponseData.success((Object)this.iTrainingProviderService.getTrainingInfo(param));
    }

    @ApiOperationSupport(order=1000)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u57f9\u8bad\u7684\u5de5\u4f5c\u7c7b\u522b")
    @GetMapping(value={"getTrainingWorkType"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType() {
        return new ResponseData((Object)this.iTrainingProviderService.getTrainingWorkType());
    }

    @ApiOperationSupport(order=100)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad-\u5355\u4f4d\u62a5\u540d\u5217\u8868")
    @GetMapping(value={"getTrainingUnitEnrollList"})
    public ResponseData<LayuiGridData<TrainingUnitEnrollVo>> getTrainingUnitEnrollList(TrainingEnrollSearchParam param) {
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        param.setUserArea(ShiroUtil.getLoginAreaId());
        return new ResponseData((Object)this.iTrainingProviderService.getTrainingUnitEnrollList(param));
    }

    @ApiOperationSupport(order=105)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad-\u4e2a\u4eba\u7528\u6237\u62a5\u540d\u5217\u8868")
    @GetMapping(value={"getTrainingPersonEnrollList"})
    public ResponseData<LayuiGridData<TrainingPersonEnrollVo>> getTrainingPersonEnrollList(TrainingEnrollDetailSearchParam param) {
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        param.setAreaId(ShiroUtil.getLoginAreaId());
        return new ResponseData((Object)this.iTrainingProviderService.getTrainingPersonEnrollList(param));
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u4e2a\u4eba\u62a5\u540d\u9000\u56de")
    @Log(title="\u7528\u6237\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u9000\u56de\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_admin, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"sendBack"})
    public ResponseData sendBack(@RequestBody AdminToSendBackParam param) {
        param.setOptName(ShiroUtil.getLoginUsername());
        param.setOptUserType(null);
        param.setOperationRole(null);
        this.enrollProviderService.adminToSendBack(param);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u5355\u4f4d\u62a5\u540d\u9000\u56de")
    @Log(title="\u5355\u4f4d\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u9000\u56de\u5355\u4f4d\u62a5\u540d", logModule=LogModuleTypeEnum.unit_enroll_admin, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"sendBackCrop"})
    public ResponseData sendBackCrop(@RequestBody AdminToSendBackCropParam param) {
        param.setOptName(ShiroUtil.getLoginUsername());
        param.setOptUserType(null);
        param.setOperationRole(null);
        param.setAdminToken(ShiroUtil.getUserInfo().getToken());
        this.enrollProviderService.adminTosendBackCrop(param);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u5220\u9664\u4e2a\u4eba\u62a5\u540d")
    @Log(title="\u7528\u6237\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u5220\u9664\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_admin, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"deleteEnrollDetail"})
    public ResponseData deleteEnrollDetail(@RequestBody AdminToRemoveStaffParam param) {
        param.setOptName(ShiroUtil.getLoginUsername());
        param.setOptUserType(null);
        param.setOperationRole(null);
        param.setOperationRole(null);
        param.setToken(Long.valueOf(ShiroUtil.getUserInfo().getToken()));
        this.enrollProviderService.adminToDeletePersonalEnrollDetail(param);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u5220\u9664\u5355\u4f4d\u62a5\u540d")
    @Log(title="\u5355\u4f4d\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u5220\u9664\u5355\u4f4d\u62a5\u540d", logModule=LogModuleTypeEnum.unit_enroll_admin, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"deleteEnroll"})
    public ResponseData deleteEnroll(@RequestBody AdminToRmCropEnrollParam param) {
        param.setOptName(ShiroUtil.getLoginUsername());
        param.setOptUserType(null);
        param.setOperationRole(null);
        this.enrollProviderService.adminToDeleteEnroll(param);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperationSupport(order=200)
    @Log(title="\u7528\u6237\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u6279\u91cf\u64cd\u4f5c", logModule=LogModuleTypeEnum.user_enroll_admin, type=LogTypeEnum.type_opt)
    @ApiOperation(value="\u4e2a\u4eba\u62a5\u540d\u5217\u8868\u6279\u91cf\u64cd\u4f5c\uff080\u9000\u56de 1\u5220\u9664 2\u751f\u6210\u8bc1\u4e66\uff09")
    @PostMapping(value={"enrollDetailOptBatch"})
    public ResponseData enrollDetailOptBatch(@RequestBody List<TrainEnrollDetailOptBatchParam> paramList) {
        for (TrainEnrollDetailOptBatchParam param : paramList) {
            param.setOptName(ShiroUtil.getLoginUsername());
            param.setOptUserType(null);
            param.setOperationRole(null);
            param.setToken(Long.valueOf(ShiroUtil.getUserInfo().getToken()));
            param.setLoginUserId(Long.valueOf(ShiroUtil.getLoginUserId()));
        }
        return ResponseData.success((Object)this.enrollProviderService.enrollDetailOptBath(paramList));
    }

    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u5355\u4f4d\u62a5\u540d\u5217\u8868\u6279\u91cf\u64cd\u4f5c")
    @Log(title="\u5355\u4f4d\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u6279\u91cf\u64cd\u4f5c\uff080\u9000\u56de 1\u5220\u9664 2\u751f\u6210\u8bc1\u4e66\uff09", logModule=LogModuleTypeEnum.unit_enroll_admin, type=LogTypeEnum.type_opt)
    @PostMapping(value={"enrollOptBatch"})
    public ResponseData enrollOptBatch(@RequestBody List<TrainEnrollOptBatchParam> paramList) {
        for (TrainEnrollOptBatchParam param : paramList) {
            param.setOptName(ShiroUtil.getLoginUsername());
            param.setOptUserType(null);
            param.setOperationRole(null);
            param.setAdminToken(ShiroUtil.getUserInfo().getToken());
            param.setLoginUserId(ShiroUtil.getLoginUserId());
        }
        this.enrollProviderService.enrollOptBath(paramList);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=200)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u6062\u590d\u62a5\u540d\u6570\u636e")
    @Log(title="\u7528\u6237\u62a5\u540d\u7ba1\u7406_\u76d1\u7ba1\u7aef-\u6062\u590d\u4e2a\u4eba\u7528\u6237\u62a5\u540d\u6570\u636e", logModule=LogModuleTypeEnum.user_enroll_admin, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"rePersonalEnrollData"})
    public ResponseData rePersonalEnrollData(@RequestBody ResurgenceEnrollDataParam param) {
        return ResponseData.success();
    }

    @ApiOperationSupport(order=10)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u4fee\u6539\u57f9\u8bad\u8be6\u60c5(\u57fa\u672c\u4fe1\u606f\u3001\u8003\u8bd5\u4fe1\u606f)")
    @Log(title="\u4fee\u6539\u57f9\u8bad\u4fe1\u606f", logModule=LogModuleTypeEnum.training, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"updateTrainingDetail"})
    public ResponseData<String> updateTrainingDetail(@RequestBody TrainingUpdateParam param) throws IllegalAccessException {
        param.setModifyPerson(ShiroUtil.getUserInfo().getName());
        param.setUserArea(ShiroUtil.getUserInfo().getAreaId());
        param.setToken(ShiroUtil.getShiroPrincipal().getUser().getToken());
        param.setUpdateBy(ShiroUtil.getLoginUserId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        Integer rst = this.iTrainingProviderService.updateTrainingDetail(param);
        if (rst == -1) {
            return ResponseData.fail((String)"\u57f9\u8bad\u5df2\u4e0a\u67b6\uff0c\u4e0d\u53ef\u7f16\u8f91\uff01");
        }
        return ResponseData.success();
    }

    @ApiOperationSupport(order=25)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u53d8\u66f4\u8bb0\u5f55")
    @GetMapping(value={"getTrainChangeRecord"})
    public ResponseData<LayuiGridData<TrainingChangeRecord>> getTrainChangeRecord(TidParam param) {
        return new ResponseData((Object)this.iTrainingProviderService.listTrainChangeRecord(param));
    }

    @ApiOperationSupport(order=11)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u4fee\u6539\u57f9\u8bad\u4e0a\u4e0b\u67b6\u72b6\u6001")
    @PostMapping(value={"changeTrainingStatus"})
    public ResponseData<String> changeTrainingStatus(@RequestBody TrainingStatusUpdateParam param) {
        param.setAreaId(ShiroUtil.getUserInfo().getAreaId());
        param.setToken(ShiroUtil.getShiroPrincipal().getUser().getToken());
        param.setModifyPerson(ShiroUtil.getUserInfo().getName());
        Integer rst = this.iTrainingProviderService.changeTrainingStatus(param);
        if (rst == null || rst.equals(0)) {
            return ResponseData.fail();
        }
        return ResponseData.success();
    }

    @ApiOperationSupport(order=15)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u65b0\u589e \u57f9\u8bad\u4fe1\u606f(\u57fa\u672c\u4fe1\u606f\u3001\u8003\u8bd5\u4fe1\u606f)")
    @Log(title="\u65b0\u589e\u57f9\u8bad\u4fe1\u606f", logModule=LogModuleTypeEnum.training, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"addTrainingDetail"})
    public ResponseData<Long> addTrainingDetail(@RequestBody TrainingAddParam param) {
        param.setUserArea(ShiroUtil.getUserInfo().getAreaId());
        param.setUid(ShiroUtil.getLoginUserId());
        param.setUserAreaLevel(StringUtils.getAreaLevel((Long)ShiroUtil.getUserInfo().getAreaId()));
        param.setCouldModifyArea(ShiroUtil.getUserInfo().getAreaId());
        param.setCreateName(ShiroUtil.getUserInfo().getName());
        param.setToken(ShiroUtil.getShiroPrincipal().getUser().getToken());
        param.setCreateBy(ShiroUtil.getLoginUserId());
        param.setUpdateBy(ShiroUtil.getLoginUserId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        param.setVersion(ShiroUtil.getTrainingVersion());
        return new ResponseData((Object)this.iTrainingProviderService.addTrainingDetail(param));
    }

    @ApiOperationSupport(order=20)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u5220\u9664\u57f9\u8bad")
    @Log(title="\u5220\u9664\u57f9\u8bad", logModule=LogModuleTypeEnum.training, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"removeBatchTrainingInfo"})
    public ResponseData<String> removeBatchTrainingInfo(@RequestBody TrainingDelParam param) {
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        param.setUid(ShiroUtil.getLoginUserId());
        this.iTrainingProviderService.removeBatchTrainingInfo(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=25)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u514b\u9686\u57f9\u8bad")
    @GetMapping(value={"cloneTrainByTid"})
    public ResponseData<Long> cloneTrainByTid(Long tid) {
        String version = ShiroUtil.getTrainingVersion();
        return ResponseData.success((Object)this.iTrainingProviderService.cloneTrainByTid(tid, ShiroUtil.getLoginUserId(), Boolean.valueOf(ShiroUtil.isSpecifiedUser()), version));
    }

    @ApiOperationSupport(order=1000)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u63d0\u524d\u66f4\u65b0\u6240\u6709\u57f9\u8bad\u72b6\u6001")
    @PostMapping(value={"upateAllEnrollAStatus"})
    public ResponseData upateAllEnrollAStatus() {
        this.enrollProviderService.upateAllEnrollStatus();
        return ResponseData.success();
    }

    @ApiOperationSupport(order=1001)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u83b7\u53d6\u76ee\u6807\u8bc1\u4e66\u5217\u8868")
    @GetMapping(value={"getCertificateList"})
    public ResponseData<List<Certificate>> getCertificateList() {
        return new ResponseData((Object)this.certificateProviderService.getCertificateList());
    }

    @ApiOperationSupport(order=1002)
    @RequiresPermissions(value={"training.management.training.edit"})
    @ApiOperation(value="\u66f4\u65b0\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u7684\u57f9\u8bad\u533a\u57df")
    @GetMapping(value={"updateHseTrainArea"})
    public ResponseData<Integer> updateHseTrainArea() {
        return new ResponseData((Object)this.iTrainingProviderService.updateHseTrainArea());
    }
}

