/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.QueryUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserCropParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CompanyModifyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropStaffEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.CropTrainingListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForCorp;
import cn.smarthse.radiationTraining.modules.training.vo.training.CropTrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=60, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u5355\u4f4d\u8d26\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/corp"})
public class SysUserCropController
extends ControllerSupport {
    @DubboReference
    private IUserCropProviderService userProviderService;
    @DubboReference
    private ITrainingProviderServiceForCorp trainingProviderServiceForCorp;

    @ApiOperation(value="\u5355\u4f4d\u8d26\u53f7-\u5217\u8868")
    @GetMapping(value={"getUserList"})
    public ResponseData<LayuiGridData<UserCropListVo>> getUserList(QueryUserParam param) {
        param.setUserArea(ShiroUtil.getUserInfo().getAreaId());
        param.setAreaLevel(StringUtils.getAreaLevel((Long)ShiroUtil.getUserInfo().getAreaId()));
        param.setIsTest(AccountUtil.isSpecifiedUserName((String)ShiroUtil.getLoginUsername()) ? null : Integer.valueOf(0));
        return new ResponseData((Object)this.userProviderService.getUserList(param));
    }

    @ApiOperation(value="\u5355\u4f4d\u8d26\u53f7-\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u8d26\u53f7id", dataTypeClass=Long.class)})
    @GetMapping(value={"getUser"})
    public ResponseData<UserCropVo> getUser(Long userId) {
        return new ResponseData((Object)this.userProviderService.getUserVo(userId));
    }

    @ApiOperation(value="\u5355\u4f4d\u8d26\u53f7-\u7f16\u8f91")
    @PostMapping(value={"saveUser"})
    @RequiresPermissions(value={"sys:user:crop:edit"})
    @Log(title="\u5355\u4f4d\u8d26\u53f7-\u7f16\u8f91", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveUser(@RequestBody SaveUserCropParam param) {
        this.userProviderService.saveUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5355\u4f4d\u8d26\u53f7-\u5220\u9664")
    @PostMapping(value={"del"})
    @RequiresPermissions(value={"sys:user:crop:edit"})
    @Log(title="\u5355\u4f4d\u8d26\u53f7-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdsParam param) {
        this.userProviderService.del(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u5355\u4f4d\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528")
    @PostMapping(value={"forbiddenAdmin"})
    @RequiresPermissions(value={"sys:user:crop:edit"})
    @Log(title="\u5355\u4f4d\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenParam param) {
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5355\u4f4d\u8d26\u53f7-\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"resetPassword"})
    @RequiresPermissions(value={"sys:user:crop:edit"})
    @Log(title="\u5355\u4f4d\u8d26\u53f7-\u91cd\u7f6e\u5bc6\u7801", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> resetPassword(@RequestBody IdsParam param) {
        this.userProviderService.resetPassword(param.getIdList(), param.getLoginUserId());
        return ResponseData.success((String)"\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\u4e3a\u201c%s\u201d\uff01", (Object)"Zyj@2022");
    }

    @ApiOperation(value="\u67e5\u5355\u4f4d\u7684\u57f9\u8bad\u5217\u8868")
    @GetMapping(value={"getCropTrain"})
    public ResponseData<LayuiGridData<CropTrainingListVo>> getCropTrain(CropTrainingListParam param) {
        return new ResponseData((Object)this.trainingProviderServiceForCorp.getCropTrain(param));
    }

    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u57fa\u7840\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId"), @ApiImplicitParam(name="cid", value="\u5355\u4f4dId")})
    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<TrainingBaseInfoVo> getTrainingBaseInfo(Long tid, Long cid) {
        TrainingSearchParam param = new TrainingSearchParam();
        param.setTrainingId(tid);
        param.setCid(cid);
        return new ResponseData((Object)this.trainingProviderServiceForCorp.getTrainingBaseInfoForCorp(param));
    }

    @ApiOperation(value="\u67e5\u5355\u4f4d\u7684\u62a5\u540d\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"getCropEnroll"})
    public ResponseData<LayuiGridData<TrainingPersonEnrollVo>> getCropEnroll(CropStaffEnrollSearchParam param) {
        return new ResponseData((Object)this.trainingProviderServiceForCorp.getCropTrain(param));
    }

    @ApiOperation(value="\u5355\u4f4d-\u5220\u9664\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"listDelEnroll"})
    public ResponseData<LayuiGridData<TrainingPersonEnrollVo>> listDelEnroll(CropStaffEnrollSearchParam param) {
        return new ResponseData((Object)this.trainingProviderServiceForCorp.listDelEnroll(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4f4d\u5df2\u62a5\u540d\u57f9\u8bad\u7684\u5de5\u4f5c\u7c7b\u522b")
    @GetMapping(value={"getTrainingWorkType"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType(Long cid) {
        return new ResponseData((Object)this.trainingProviderServiceForCorp.getTrainingWorkType(cid));
    }

    @ApiOperation(value="\u540c\u6b65\u63a5\u53e3-\u4fee\u6539\u5355\u4f4d")
    @PostMapping(value={"updateCrop"})
    @Log(title="\u540c\u6b65-\u5355\u4f4d\u8d26\u53f7-\u7f16\u8f91", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveUser(@RequestBody List<CompanyModifyVo> param) {
        this.userProviderService.modifyCompanyFromHSE(param);
        return ResponseData.success();
    }
}

