/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.enums.SystemDeploymentSourceEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.common.model.GeneralListParam;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceVirtuallyEnum;
import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.CompanyAreaChangeInfoModel;
import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.CompanyAreaChangeSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyBaseChangeInfoProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3AddParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3EditParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3ListParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3ListVo;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.admin.model.hse.ImportCompanyData;
import cn.smarthse.radiationTraining.modules.admin.service.easyexcel.SysCompanyUserImportAddListener;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollNumberVo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u4eba\u5355\u4f4d\u7528\u6237"})
@ApiSupport(order=59)
@Validated
@RestController
@RequestMapping(value={"/v3/sys/companyUser"})
public class SysCompanyUserV3Controller
extends ControllerSupport {
    @DubboReference(registry={"local_nacos"})
    private ITuEnrollProviderService tuEnrollProviderService;
    @DubboReference(registry={"public_nacos"})
    private IDcCompanyService dcCompanyService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private ISysUserThirdService sysUserThirdService;
    @DubboReference(registry={"public_nacos"})
    private ICompanyBaseChangeInfoProviderService companyBaseChangeInfoProviderService;

    @ApiOperation(value="\u5217\u8868")
    @RequiresPermissions(value={"training.sys.user.view"})
    @GetMapping(value={"getList"})
    public ResponseData<JqGridData<CompanyUserV3ListVo>> getList(CompanyUserV3ListParam param) {
        this.setSearchListParam(param);
        JqGridData jqGridData = this.dcCompanyService.getCompanyUserV3List(param);
        if (CollUtil.isNotEmpty((Collection)jqGridData.getRows())) {
            List cidList = jqGridData.getRows().stream().map(CompanyUserV3ListVo::getId).collect(Collectors.toList());
            Map<Long, EnrollNumberVo> map = this.tuEnrollProviderService.getEnrollCount(cidList).stream().collect(Collectors.toMap(EnrollNumberVo::getToken, v -> v));
            for (CompanyUserV3ListVo dto : jqGridData.getRows()) {
                EnrollNumberVo en = map.get(dto.getId());
                if (Objects.nonNull(en)) {
                    dto.setOnlineTrainUserId(en.getUserId());
                    dto.setNumber(Integer.valueOf(Objects.isNull(en.getNumber()) ? 0 : en.getNumber()));
                }
                if (dto.getIsRegulationVisible() == 1) {
                    dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.ZLWQ.getValue());
                    continue;
                }
                if (dto.getIsRegulationVisible() == 0 && Objects.equals(dto.getDataSource(), CompanyDataSourceEnum.OLINETRAIN.getValue())) {
                    dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.OLINETRAIN.getValue());
                    continue;
                }
                dto.setVirtuallyDataSource(CompanyDataSourceVirtuallyEnum.OTHER2.getValue());
            }
        }
        return ResponseData.success((Object)jqGridData);
    }

    private void setSearchListParam(CompanyUserV3ListParam param) {
        param.setSystemDeploymentSource(SystemDeploymentSourceEnum.ONLINE_TRAINING.getCode());
        param.setCount(Boolean.FALSE);
        param.setUserAreaId(ShiroUtil.getLoginAreaId());
        param.setUserAreaLevel(ShiroUtil.getLoginAreaLevel());
        Optional.ofNullable(param.getSearchAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaByIdV3(arg_0)).ifPresent(area -> param.setSearchAreaLevel(area.getLevel()));
        param.setIsOnlineSpecialTestUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        if (Objects.equals(param.getIsNowUser(), Boolean.TRUE)) {
            param.setLoginUserId(ShiroUtil.getLoginUserId2());
        }
    }

    @ApiOperation(value="\u5217\u8868\u603b\u6570")
    @RequiresPermissions(value={"training.sys.user.view"})
    @GetMapping(value={"getListCount"})
    public ResponseData<Long> getListCount(CompanyUserV3ListParam param) {
        this.setSearchListParam(param);
        return ResponseData.success((Object)this.dcCompanyService.getCompanyUserV3ListCount(param));
    }

    @ApiOperation(value="\u521b\u5efa\u8d26\u53f7")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"createSysUser"})
    public ResponseData<Void> createSysUser(@RequestBody GeneralListParam param) {
        return new ResponseData(this.sysUserThirdService.createSysUser(param.getIdList(), ShiroUtil.getLoginUserId2()) != false ? ResponseStateEnum.success : ResponseStateEnum.fail);
    }

    @ApiOperation(value="\u65b0\u589e\u4f01\u4e1a\u540c\u65f6\u521b\u5efa\u8d26\u53f7")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"save"})
    public ResponseData<?> save(@RequestBody @Validated CompanyUserV3AddParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId2());
        return this.dcCompanyService.saveForTrain(param) != false ? ResponseData.success((String)"Zyj@2022") : ResponseData.fail();
    }

    @ApiOperation(value="\u66f4\u65b0\u4f01\u4e1a")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"updateResource"})
    public ResponseData<Void> update(@RequestBody @Validated CompanyUserV3EditParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId2());
        param.setFullName(ShiroUtil.getLoginUsername());
        return new ResponseData(this.dcCompanyService.updateForTrain(param) != false ? ResponseStateEnum.success : ResponseStateEnum.fail);
    }

    @ApiOperation(value="\u7981\u7528\u6216\u542f\u7528")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"enableOrDisable/{flag}"})
    public ResponseData<Void> enableOrDisable(@RequestBody GeneralListParam param, @PathVariable Integer flag) {
        return new ResponseData(this.sysUserThirdService.disableOrEnableUserByCidList(param.getIdList(), flag, ShiroUtil.getLoginUserId2()) > 0 ? ResponseStateEnum.success : ResponseStateEnum.fail);
    }

    @ApiOperation(value="\u8425\u4e1a\u72b6\u6001\u53d8\u66f4")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"changeBusinessState"})
    public ResponseData<Void> changeBusinessState(Long id, Byte businessState) {
        return new ResponseData(this.dcCompanyService.changeBusinessState(id, businessState, ShiroUtil.getLoginUserId2()) != false ? ResponseStateEnum.success : ResponseStateEnum.fail);
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"resetPassword"})
    public ResponseData<?> resetPassword(Long userId) {
        return this.sysUserThirdService.resetPasswordByUserId(userId, "Zyj@2022", ShiroUtil.getLoginUserId2()) > 0 ? ResponseData.success((String)"Zyj@2022") : ResponseData.fail();
    }

    @ApiOperation(value="\u5220\u9664\u5e76\u5220\u9664\u8d26\u53f7")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"delCompany"})
    public ResponseData<String> delCompany(@RequestBody GeneralListParam param) {
        return new ResponseData(this.dcCompanyService.delete(param.getIdList(), ShiroUtil.getLoginUserId2()) != false ? ResponseStateEnum.success : ResponseStateEnum.fail);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"importData"})
    public ResponseData<String> importData(@RequestPart(value="file") MultipartFile file, Boolean isCreateUser) {
        try (InputStream inputStream = file.getInputStream();
             ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet().headRowNumber(Integer.valueOf(3))).head(ImportCompanyData.class)).registerReadListener((ReadListener)new SysCompanyUserImportAddListener(this.organizationService, this.companyProvideBySuperviseService, this.industryProvideService, this.sysAreaProvideService, this.sysUserThirdService, ShiroUtil.getLoginUserId2(), isCreateUser))).build()});
        }
        catch (IOException e) {
            this.logger.error("\u7528\u4eba\u5355\u4f4d\u5bfc\u5165\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return ResponseData.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u8f96\u533a\u5185\u4f01\u4e1a\u53d8\u66f4\u4e00\u89c8\u8868")
    @GetMapping(value={"getChangeList"})
    @RequiresPermissions(value={"training.sys.user.view"})
    public ResponseData<JqGridData<CompanyAreaChangeInfoModel>> getChangeList(CompanyAreaChangeSearchModel param) {
        param.setAreaId(ShiroUtil.getLoginAreaId());
        param.setAreaLevel(Integer.valueOf(ShiroUtil.getLoginAreaLevel().byteValue()));
        PageInfo rst = this.companyBaseChangeInfoProviderService.getAreaChangeInfoPage(param);
        return ResponseData.success((Object)new JqGridData(rst, new JqGridParam(param.getRows(), param.getPage())));
    }

    @ApiOperation(value="\u8f96\u533a\u5185\u4f01\u4e1a\u53d8\u66f4\u4e00\u89c8\u8868-\u5bfc\u51fa")
    @RequestLimit
    @RequiresPermissions(value={"training.sys.user.view"})
    @GetMapping(value={"/exportData"}, produces={"application/octet-stream"})
    public void exportData(HttpServletResponse response, CompanyAreaChangeSearchModel param) throws IOException {
        param.setAreaId(ShiroUtil.getLoginAreaId());
        param.setAreaLevel(Integer.valueOf(ShiroUtil.getLoginAreaLevel().byteValue()));
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        PageInfo result = this.companyBaseChangeInfoProviderService.getAreaChangeInfoPage(param);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(String.format("\u8f96\u533a\u5185\u4f01\u4e1a\u53d8\u66f4\u4e00\u89c8\u8868%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        String templateFileName = new ClassPathResource("templates/export/employerChangeTemplates.xlsx").getFile().getPath();
        try (ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream(), CompanyAreaChangeInfoModel.class).withTemplate(templateFileName).autoCloseStream(Boolean.FALSE).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.FALSE).build();
            excelWriter.fill((Object)result.getList(), fillConfig, writeSheet);
        }
        catch (Exception e) {
            this.logger.error("\u8f96\u533a\u5185\u4f01\u4e1a\u53d8\u66f4\u4e00\u89c8\u8868\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
    }

    @Generated
    public SysCompanyUserV3Controller() {
    }
}

