/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.rho.modules.sys.model.b.param.hse.training.RhoCompanyUserPageParam;
import cn.smarthse.rho.modules.sys.model.b.vo.hse.training.RhoCompanyHseTrainingVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyHseTrainingProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u653e\u5c04\u7528\u4eba\u5355\u4f4d\u7528\u6237"})
@ApiSupport(order=59)
@Validated
@RestController
@RequestMapping(value={"/rho/company"})
public class RhoCompanyController
extends ControllerSupport {
    @DubboReference(registry={"local_nacos"})
    private ICompanyHseTrainingProvider rhoCompanyProvider;
    @DubboReference(registry={"local_nacos"})
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference(registry={"local_nacos"})
    private ISysAreaProvider areaProvider;

    @ApiOperation(value="\u5217\u8868")
    @RequiresPermissions(value={"training.sys.user.view"})
    @GetMapping(value={"getUserList"})
    public ResponseData<LayuiGridData<RhoCompanyHseTrainingVo>> getUserListForAdmin(RhoCompanyUserPageParam param) {
        param.setUserAreaId(ShiroUtil.getLoginAreaId());
        param.setUserAreaLevel(Integer.valueOf(ShiroUtil.getLoginAreaLevel().byteValue()));
        param.setLoginUserId(ShiroUtil.getLoginUserId2());
        if (param.getAreaId() != null) {
            SysAreaVo area = this.areaProvider.getAreaById(param.getAreaId());
            if (area == null) {
                throw new ServiceException("\u8be5\u5730\u533a\u4e0d\u5b58\u5728\uff01");
            }
            param.setLevel(area.getLevel());
        }
        return new ResponseData((Object)this.rhoCompanyProvider.getRhoUserListForHseTrainingAdmin(param));
    }

    @Log(type=LogTypeEnum.type_opt_reset, logModule=LogModuleTypeEnum.sys, title="\u7cfb\u7edf\u7ba1\u7406-\u653e\u5c04\u536b\u751f\u533b\u9662\u5217\u8868-\u91cd\u7f6e\u5bc6\u7801")
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @RequiresPermissions(value={"training.sys.user.edit"})
    @PostMapping(value={"/resetPassword"})
    public ResponseData<String> resetPassword(@RequestBody @Validated IdParam param) {
        if (param.getId() == null) {
            return ResponseData.fail((String)"\u8bf7\u9009\u62e9\u7528\u6237\uff01");
        }
        Boolean b = this.sysUserServiceProvider.resetPasswordForSup(param);
        return b != false ? ResponseData.success((String)"Zyj@2022") : ResponseData.fail();
    }

    @Generated
    public RhoCompanyController() {
    }
}

