/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.param;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysParam;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysParamVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=64, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u6570\u636e\u5b57\u5178"})
@RestController
@RequestMapping(value={"/sys/param"})
public class SysParamController {
    @DubboReference
    private ISysParamProviderService sysParamProviderService;

    @ApiOperation(value="\u6570\u636e\u5b57\u5178-\u5217\u8868\u5206\u9875")
    @GetMapping(value={"/getParamListData"})
    public ResponseData<LayuiGridData<SysParamVo>> getParamListData(ParamQueryParam param) {
        return new ResponseData((Object)this.sysParamProviderService.getParamListData(param));
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178-\u5217\u8868")
    @GetMapping(value={"/getParamList"})
    public ResponseData<List<SysParamVo>> getParamList(ParamQueryParam param) {
        return new ResponseData((Object)this.sysParamProviderService.getParamList(param));
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178-\u7f16\u8f91\u3001\u6dfb\u52a0")
    @PostMapping(value={"/saveParam"})
    @RequiresPermissions(value={"sys:edit"})
    @Log(title="\u6570\u636e\u5b57\u5178-\u7f16\u8f91", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveParam(@RequestBody SaveSysParam param) {
        this.sysParamProviderService.saveParam(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178-\u5220\u9664")
    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"sys:edit"})
    @Log(title="\u6570\u636e\u5b57\u5178-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdsParam param) {
        this.sysParamProviderService.delParam(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178-\u505c\u7528\u3001\u542f\u7528")
    @PostMapping(value={"/forbiddenParam"})
    @RequiresPermissions(value={"sys:edit"})
    @Log(title="\u6570\u636e\u5b57\u5178-\u505c\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenParam(@RequestBody ForbiddenParam param) {
        this.sysParamProviderService.forbiddenParam(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u5206\u9875\uff0c\u7528\u4e8e\u4e0b\u62c9\u6846")
    @GetMapping(value={"/searchByTypeAndKeyword"})
    public ResponseData<List<SysParam>> searchByTypeAndKeyword(String type, String keyword) {
        return new ResponseData((Object)this.sysParamProviderService.getByTypeAndKeyword(type, keyword));
    }
}

