/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.order;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.admin.service.order.IPayService;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderLog;
import cn.smarthse.radiationTraining.modules.sys.param.order.OrderRefundParam;
import cn.smarthse.radiationTraining.modules.sys.param.order.QueryOrderParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.AcUserInfoParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderLogService;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderService;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderDetailModel;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderModel;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderRefundAuditVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.AcUserInfoVo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/order"})
public class AdminOrderController
extends ControllerSupport {
    private final String info_prefix = "[\u8ba2\u5355\u7ba1\u7406-\u540e\u53f0]";
    private final IPayService payService;
    @DubboReference
    private ISysOrderService sysOrderService;
    @DubboReference
    private ISysOrderLogService sysOrderLogService;
    @DubboReference
    private IUserProviderService userProviderService;

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/getOrderListData"})
    @RequiresPermissions(value={"training.beforeemployment.order.view"})
    public ResponseData<LayuiGridData<SysOrderModel>> getOrderListData(QueryOrderParam param) {
        this.logger.debug("{}-\u67e5\u8be2\u8ba2\u5355\u5217\u8868-param={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u540e\u53f0]", (Object)param);
        return ResponseData.success((Object)this.sysOrderService.getOrderListData(param));
    }

    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/getOrderDetails"})
    @RequiresPermissions(value={"training.beforeemployment.order.view"})
    public ResponseData<SysOrderDetailModel> getOrderDetails(IdParam param) {
        this.logger.info("{}-\u8ba2\u5355\u8be6\u60c5-param={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u540e\u53f0]", (Object)param);
        SysOrderDetailModel orderModel = this.sysOrderService.getOrderDetails(param.getId());
        return ResponseData.success((Object)orderModel);
    }

    @ApiOperation(value="\u9000\u6b3e\u7533\u8bf7\u5ba1\u6838\u4fe1\u606f\u3001\u9000\u6b3e\u4fe1\u606f")
    @GetMapping(value={"/getRefundAuditDetails"})
    @RequiresPermissions(value={"training.beforeemployment.order.view"})
    public ResponseData<SysOrderRefundAuditVo> getRefundAuditDetails(IdParam param) {
        this.logger.info("{}-\u8ba2\u5355\u8be6\u60c5-\u7cfb\u7edf\u8ba2\u5355\u53f7={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u540e\u53f0]", (Object)param.getId());
        SysOrderRefundAuditVo refundAuditVo = this.sysOrderService.getSysOrderRefundAuditVo(param.getId());
        return ResponseData.success((Object)refundAuditVo);
    }

    @ApiOperation(value="\u8ba2\u5355\u9000\u6b3e\u901a\u8fc7\u3001\u62d2\u7edd")
    @PostMapping(value={"/refundAudit"})
    @RequiresPermissions(value={"training.beforeemployment.order.edit"})
    @Log(title="\u8ba2\u5355\u9000\u6b3e", logModule=LogModuleTypeEnum.order, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> refundAudit(@RequestBody OrderRefundParam param) {
        this.logger.info("{}-\u8ba2\u5355\u9000\u6b3e-\u9000\u6b3e\u7533\u8bf7orderFundId={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u540e\u53f0]", (Object)param.getOrderRefundId());
        this.payService.refundAudit(param);
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u8ba2\u5355\u64cd\u4f5c\u8bb0\u5f55")
    @GetMapping(value={"/getOrderLogList"})
    @RequiresPermissions(value={"training.beforeemployment.order.view"})
    public ResponseData<List<SysOrderLog>> getOrderLogList(IdParam orderId) {
        this.logger.debug("{}-\u8ba2\u5355\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2-orderId={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u540e\u53f0]", (Object)orderId.getId());
        return ResponseData.success((Object)this.sysOrderLogService.getOrderLogList(orderId.getId(), null));
    }

    @ApiOperation(value="\u83b7\u53d6\u654f\u611f\u4fe1\u606f")
    @GetMapping(value={"/getAcInfo"})
    @RequiresPermissions(value={"training.beforeemployment.order.view"})
    @Log(title="\u83b7\u53d6\u654f\u611f\u4fe1\u606f", logModule=LogModuleTypeEnum.order_user_info_admin, type=LogTypeEnum.type_view_user_sensitive_info)
    public ResponseData<AcUserInfoVo> getAcInfo(AcUserInfoParam param) {
        UserVo userVo = this.userProviderService.getUserVo(param.getUserId());
        if (userVo == null) {
            return ResponseData.fail((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        AcUserInfoVo vo = new AcUserInfoVo();
        if (param.getIncludeIdCard() == 1) {
            vo.setIdCard(userVo.getIdcard());
        }
        if (param.getIncludePhone() == 1) {
            vo.setPhone(userVo.getPhone());
        }
        if (param.getIncludeName() == 1) {
            vo.setName(userVo.getName());
        }
        return ResponseData.success((Object)vo);
    }

    @Generated
    public AdminOrderController(IPayService payService) {
        this.payService = payService;
    }
}

