/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.home;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.param.training.AssoScoreListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RhoTrainHomeCropParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RhoTrainHomeUserParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeCetParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeCropParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeUserParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.training.AssoScoreListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.RhoTrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.RhoTrainHomeUserVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCetVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeUserVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingHomeListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingHomeVo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=3, author="\u891a\u6d77\u6d0b")
@Api(tags={"\u9996\u9875"})
@RestController
@RequestMapping(value={"/home"})
public class HomeController
extends ControllerSupport {
    @DubboReference
    private ITrainingProviderService trainingProviderService;

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u7edf\u8ba1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaId", value="\u884c\u653f\u533a\u5212id", dataTypeClass=Long.class)})
    @GetMapping(value={"getTrainingStatisticList"})
    public ResponseData<LayuiGridData<TrainingHomeVo>> getTrainingStatisticList(TrainHomeListParam param) {
        if (param.getAreaId() == null) {
            param.setAreaId(ShiroUtil.getLoginAreaId());
        }
        if (param.getYear() == null) {
            param.setYear(Integer.valueOf(Calendar.getInstance().get(1)));
        }
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        }
        return new ResponseData((Object)this.trainingProviderService.getTrainingHomeList(param));
    }

    @ApiOperationSupport(order=5)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u5730\u56fe\u5bf9\u5e94\u6e05\u5355(1-\u672a\u57f9\u8bad; 2-\u5df2\u57f9\u8bad\u672a\u8003\u8bd5; 3-\u5df2\u57f9\u8bad\u5df2\u8003\u8bd5\u901a\u8fc7)")
    @GetMapping(value={"getUntrainedList"})
    public ResponseData<LayuiGridData<TrainingHomeListVo>> getUntrainedList(TrainHomeListParam param) {
        return new ResponseData((Object)this.trainingProviderService.getUntrainedList(param));
    }

    @ApiOperationSupport(order=10)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u7528\u4eba\u5355\u4f4d\u57f9\u8bad\u6863\u6848")
    @PostMapping(value={"getCropTrainList"})
    public ResponseData<LayuiGridData<TrainHomeCropVo>> getCropTrainList(@RequestBody TrainHomeCropParam param) {
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.trainingProviderService.getCropTrainList(param));
    }

    @ApiOperationSupport(order=11)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u5355\u4f4d\u57f9\u8bad\u6863\u6848-\u5bfc\u51fa")
    @PostMapping(value={"/cropTrainExport"}, produces={"application/octet-stream"})
    public void exportCompany(HttpServletResponse response, @RequestBody TrainHomeCropParam param) {
        param.setLimit(Integer.MAX_VALUE);
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        List list = this.trainingProviderService.getCropTrainExportList(param);
        try {
            InputStream inputStream = new ClassPathResource("templates/export/unitTrainExportTmp.xlsx").getInputStream();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u7528\u4eba\u5355\u4f4d\u57f9\u8bad\u6863\u6848%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(inputStream).sheet("Sheet1").doWrite((Collection)list);
            inputStream.close();
        }
        catch (Exception e) {
            this.logger.error("Exception:{}", (Throwable)e);
        }
    }

    @ApiOperationSupport(order=15)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u4eba\u5458\u6863\u6848")
    @PostMapping(value={"getUserTrainList"})
    public ResponseData<LayuiGridData<TrainHomeUserVo>> getUserTrainList(@RequestBody TrainHomeUserParam param) {
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.trainingProviderService.getUserTrainList(param));
    }

    @ApiOperationSupport(order=16)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u4eba\u5458\u6863\u6848-\u8bc1\u4e66\u4fe1\u606f")
    @PostMapping(value={"getUserCetList"})
    public ResponseData<List<TrainHomeCetVo>> getUserCetList(@RequestBody TrainHomeCetParam param) {
        param.setUserArea(ShiroUtil.getLoginAreaId());
        return new ResponseData((Object)this.trainingProviderService.getUserCetList(param));
    }

    @ApiOperationSupport(order=17)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u4eba\u5458\u6863\u6848-\u5bfc\u51fa")
    @PostMapping(value={"/userTrainExport"}, produces={"application/octet-stream"})
    public void exportUserTrain(HttpServletResponse response, @RequestBody TrainHomeUserParam param) {
        param.setLimit(Integer.MAX_VALUE);
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        List list = this.trainingProviderService.getUserTrainCetExportList(param);
        try {
            InputStream inputStream = new ClassPathResource("templates/export/userTrainCetExportTmp.xlsx").getInputStream();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u4eba\u5458\u6863\u6848%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(inputStream).sheet("Sheet1").doWrite((Collection)list);
            inputStream.close();
        }
        catch (Exception e) {
            this.logger.error("Exception:{}", (Throwable)e);
        }
    }

    @ApiOperationSupport(order=50)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u5728\u7ebf-\u7528\u4eba\u5355\u4f4d\u57f9\u8bad\u6863\u6848")
    @GetMapping(value={"getCropTrainListForRho"})
    public ResponseData<LayuiGridData<RhoTrainHomeCropVo>> getCropTrainListForRho(RhoTrainHomeCropParam param) {
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.trainingProviderService.getCropTrainListForRho(param));
    }

    @ApiOperationSupport(order=51)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u5728\u7ebf-\u7528\u4eba\u5355\u4f4d\u57f9\u8bad\u6863\u6848-\u5bfc\u51fa")
    @PostMapping(value={"/cropTrainExportForRho"}, produces={"application/octet-stream"})
    public void exportCompanyForRho(HttpServletResponse response, @RequestBody RhoTrainHomeCropParam param) {
        param.setLimit(Integer.MAX_VALUE);
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        LayuiGridData cropTrainListForRho = this.trainingProviderService.getCropTrainListForRho(param);
        List list = cropTrainListForRho.getData();
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u653e\u5c04\u8bca\u7597\u673a\u6784\u57f9\u8bad\u6863\u6848%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), RhoTrainHomeCropVo.class).sheet("Sheet1").relativeHeadRowIndex(Integer.valueOf(1))).doWrite((Collection)list);
        }
        catch (Exception e) {
            this.logger.error("Exception:{}", (Throwable)e);
        }
    }

    @ApiOperationSupport(order=53)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u5728\u7ebf-\u4eba\u5458\u57f9\u8bad\u6863\u6848")
    @GetMapping(value={"getUserTrainListForRho"})
    public ResponseData<LayuiGridData<RhoTrainHomeUserVo>> getUserTrainListForRho(RhoTrainHomeUserParam param) {
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.trainingProviderService.getUserTrainListForRho(param));
    }

    @ApiOperationSupport(order=54)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u5728\u7ebf-\u4eba\u5458\u57f9\u8bad\u6863\u6848-\u5bfc\u51fa")
    @PostMapping(value={"/userTrainExportForRho"}, produces={"application/octet-stream"})
    public void userTrainExportForRho(HttpServletResponse response, @RequestBody RhoTrainHomeUserParam param) {
        param.setLimit(Integer.MAX_VALUE);
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        LayuiGridData userTrainListForRho = this.trainingProviderService.getUserTrainListForRho(param);
        List list = userTrainListForRho.getData();
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u653e\u5c04\u536b\u751f\u5de5\u4f5c\u4eba\u5458\u57f9\u8bad\u6863\u6848%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), RhoTrainHomeUserVo.class).sheet("Sheet1").relativeHeadRowIndex(Integer.valueOf(1))).doWrite((Collection)list);
        }
        catch (Exception e) {
            this.logger.error("Exception:{}", (Throwable)e);
        }
    }

    @ApiOperationSupport(order=61)
    @RequiresPermissions(value={"training.management.training.view"})
    @ApiOperation(value="\u534f\u4f1a\u57f9\u8bad-\u6210\u7ee9\u5217\u8868")
    @GetMapping(value={"listScoreForAssociation"})
    public ResponseData<LayuiGridData<AssoScoreListVo>> listScoreForAssociation(AssoScoreListParam param) {
        param.setUserArea(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.trainingProviderService.listScoreForAssociation(param));
    }

    @Generated
    public HomeController() {
    }
}

