/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller;

import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.health.supervise.enums.sys.UserSystemWideEnum;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysPermissionV3Service;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.AesUtil;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import com.alibaba.fastjson.JSONObject;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u540e\u53f0-\u767b\u5f55"})
@RestController
@RequestMapping(value={"/login"})
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference(registry={"public_nacos"})
    private ISysPermissionV3Service sysPermissionV3Service;

    @ApiOperation(value="\u76d1\u7ba1\u5355\u70b9\u767b\u5f55", notes="sign\u6709\u6548\u65f6\u95f410min")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sign", value="\u7b7e\u540d", required=true, paramType="query", dataTypeClass=String.class)})
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module7)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u76d1\u7ba1\u5355\u70b9\u767b\u5165")
    @PostMapping(value={"/cas"})
    public ResponseData<LoginData> loginByCas(String sign) {
        String decrypt = AesUtil.decrypt((String)sign);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        String username = (String)jsonObject.getObject("username", String.class);
        String name = (String)jsonObject.getObject("name", String.class);
        Long areaId = (Long)jsonObject.getObject("areaId", Long.class);
        String token = (String)jsonObject.getObject("token", String.class);
        Long time = (Long)jsonObject.getObject("time", Long.class);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class);
        CasToken casToken = new CasToken(username, name, areaId, token);
        FieldCheckUtils.checkEmptyFields((Object)casToken, (String[])new String[]{"username", "name", "areaId", "token"});
        long expreTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        LoginData result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="token\u5237\u65b0")
    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @GetMapping(value={"/getRouters"})
    public ResponseData<List<Tree<Long>>> getRouters() {
        return ResponseData.success((Object)this.sysPermissionV3Service.getRouters(UserSystemWideEnum.OLINETRAIN.getCode(), ShiroUtil.getLoginUserId2()));
    }

    @Generated
    public LoginController(LoginService loginService) {
        this.loginService = loginService;
    }
}

