/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.entity.SysLog;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ILogProviderService;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;

public class LogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    @DubboReference
    private ILogProviderService logProviderService;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static final int MAX_PARAM_LENGTH = 2000;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MDC.put((String)"trackId", (String)UUID.randomUUID().toString());
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) {
        MDC.clear();
    }

    private void setParams(HttpServletRequest request, SysLog syslog) {
        String param;
        if (syslog.getType().equals(LogTypeEnum.type_login.value) || request instanceof StandardMultipartHttpServletRequest) {
            return;
        }
        Map parameterMap = request.getParameterMap();
        String string = param = CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : ServletUtil.getBody((ServletRequest)request);
        if (param != null && param.length() > 2000) {
            syslog.setParams(param.substring(0, 2000));
        } else {
            syslog.setParams(param);
        }
    }
}

