/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap;

import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.radiationTraining.core.framework.bootstrap.DateBeanSerializerModifier;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.filter.MultiReadHttpServletRequestFilter;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.interceptor.BigDataLogInterceptor;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.interceptor.LogInterceptor;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.interceptor.RequestLimitInterceptor;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    @Autowired
    private OssClientProperties ossClientProperties;
    @Autowired
    private SysProperties sysProperties;
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.requestLimitInterceptor()).excludePathPatterns(new String[]{"/webjars/**", "/swagger-ui.html", "/swagger-resources/**", "/v2/**", "/images/**"}).addPathPatterns(new String[]{"/**"}).order(0x7FFFFFFE);
        registry.addInterceptor((HandlerInterceptor)this.logInterceptor()).excludePathPatterns(new String[]{"/webjars/**", "/swagger-ui.html", "/swagger-resources/**", "/v2/**", "/images/**"}).addPathPatterns(new String[]{"/**"}).order(0x7FFFFFFE);
        registry.addInterceptor((HandlerInterceptor)new BigDataLogInterceptor(this.sysProperties, this.bigDataLogProviderService)).addPathPatterns(new String[]{"/**"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        log.debug("\u914d\u7f6e\u9759\u6001\u8d44\u6e90\u8bbf\u95ee\u5904\u7406\u5668");
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + this.ossClientProperties.getOss_local() + "upload/"});
    }

    @Bean
    public RequestLimitInterceptor requestLimitInterceptor() {
        return new RequestLimitInterceptor();
    }

    @Bean
    public LogInterceptor logInterceptor() {
        return new LogInterceptor();
    }

    @Bean
    public FilterRegistrationBean<Filter> filterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new MultiReadHttpServletRequestFilter());
        ArrayList<String> urlList = new ArrayList<String>();
        urlList.add("/*");
        registration.setUrlPatterns(urlList);
        registration.setName("UrlFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.jackson2Converter());
        super.configureMessageConverters(converters);
    }

    @Bean
    public MappingJackson2HttpMessageConverter jackson2Converter() {
        MappingJackson2HttpMessageConverter jackson2Converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        objectMapper.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new DateBeanSerializerModifier()));
        jackson2Converter.setObjectMapper(objectMapper);
        return jackson2Converter;
    }
}

