/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap;

import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.AlipayProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.TaskExecutorProperties;
import cn.smarthse.radiationTraining.core.framework.utils.SpringContextHolder;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.dto.XssProperties;
import lombok.Generated;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={OssClientProperties.class, TaskExecutorProperties.class, SysProperties.class, AlipayProperties.class, XssProperties.class})
@ComponentScan(basePackages={"cn.smarthse.radiationTraining.modules.admin", "cn.smarthse.radiationTraining.modules.wqxx", "cn.smarthse.radiationTraining.core.framework", "springfox.documentation.schema"})
public class ContentConfiguration
extends BaseConfiguration {
    private final TaskExecutorProperties taskExecutorProperties;
    private final OssClientProperties ossClientProperties;

    @Bean(name={"ossClient"})
    public OssClientBean getOssClientBean() {
        this.logger.info("\u914d\u7f6eOssClientBean {}", (Object)this.ossClientProperties.getOss_bucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getOss_local());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean
    public ThreadPoolTaskExecutor taskExecutor() {
        this.logger.info("\u914d\u7f6eThreadPoolTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(this.taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> this.logger.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u4efb\u52a1\uff0c\u4efb\u52a1\u4e22\u5f03"));
        executor.initialize();
        return executor;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Generated
    public ContentConfiguration(TaskExecutorProperties taskExecutorProperties, OssClientProperties ossClientProperties) {
        this.taskExecutorProperties = taskExecutorProperties;
        this.ossClientProperties = ossClientProperties;
    }
}

