/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.user;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.enums.sys.MsgTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.sys.MsgQueryParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.IMsgService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgStatisticsVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"/msg"})
@Validated
public class MsgController {
    @DubboReference
    private IMsgService msgService;

    @GetMapping(value={"/getMsgList"})
    @ApiOperation(value="\u6d88\u606f-\u5217\u8868")
    public ResponseData<LayuiGridData<MsgVo>> getMsgList(MsgQueryParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return ResponseData.success((Object)this.msgService.getMsgList(param));
    }

    @ApiOperation(value="\u6d88\u606f-\u5df2\u8bfb(\u4e3a\u7a7a\u5219\u5168\u90e8\u5df2\u8bfb)")
    @PostMapping(value={"readMsg"})
    public ResponseData<String> readMsg(@RequestBody IdsParam param) {
        this.msgService.readMsg(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u6d88\u606f-\u5220\u9664(\u4e3a\u7a7a\u5219\u5168\u90e8\u5220\u9664)")
    @PostMapping(value={"delMsg"})
    public ResponseData<String> delMsg(@RequestBody IdsParam param) {
        this.msgService.del(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u6d88\u606f-\u7c7b\u578b\u5217\u8868")
    @PostMapping(value={"getMsgTypeList"})
    public ResponseData<List<MsgTypeEnum>> getMsgTypeList() {
        ResponseData data = new ResponseData();
        data.setResult(Arrays.asList(MsgTypeEnum.values()));
        return data;
    }

    @ApiOperation(value="\u6d88\u606f-\u672a\u8bfb\u6570\u91cf")
    @PostMapping(value={"getUnReadNum"})
    public ResponseData<Integer> getUnReadNum() {
        return ResponseData.success((String)"\u672a\u8bfb\u6570\u91cf", (Object)this.msgService.getUnReadNum(ShiroUtil.getLoginUserId()));
    }

    @ApiOperation(value="\u6d88\u606f-\u7edf\u8ba1")
    @PostMapping(value={"getMsgCount"})
    public ResponseData<MsgStatisticsVo> getMsgCount() {
        return ResponseData.success((String)"\u672a\u8bfb\u6570\u91cf", (Object)this.msgService.getMsgCount(ShiroUtil.getLoginUserId()));
    }
}

