/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.corp;

import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.param.sys.AddSysCompanyRiskParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveFeedbackParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.EditCropParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFeedbackProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.info.ICompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropSelectTraninglParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.GenerateEnrollQRCodeParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollQRCodeVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a-\u4e2a\u4eba\u4e2d\u5fc3"})
@ApiSupport(order=20, author="\u5ed6\u51cc\u4e91\u3001\u9648\u4eae")
@RestController
@RequestMapping(value={"/corp/uc"})
@Validated
public class CorpCenterController {
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private ICompanyProviderService companyProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private ISysFeedbackProviderService sysFeedbackProviderService;
    @Autowired
    RedisUtil redisUtil;

    @ApiOperationSupport(order=10)
    @ApiOperation(value="\u5f53\u524d\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/getCorpInfo"})
    public ResponseData<UserCropVo> getCorpInfo() {
        return ResponseData.success((Object)this.userCropProviderService.getFullUserInfo(ShiroUtil.getLoginUserId()));
    }

    @ApiOperationSupport(order=20)
    @ApiOperation(value="\u66f4\u65b0\u5934\u50cf")
    @PostMapping(value={"/updateHeadImg"})
    public ResponseData updateHeadImg(@RequestBody UpdateHeadImgParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        this.userCropProviderService.updateHeadImg(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=30)
    @ApiOperation(value="\u4fdd\u5b58\u6216\u8005\u66f4\u65b0\u8d26\u53f7\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public ResponseData save(@RequestBody EditCropParam param) {
        param.getSaveUserCropParam().setLoginUserId(param.getLoginUserId());
        param.getSaveUserCropParam().setUserId(param.getLoginUserId());
        this.userCropProviderService.saveUserAndCompany(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=30)
    @ApiOperation(value="\u540c\u6b65\u5371\u5bb3\u56e0\u6570")
    @PostMapping(value={"/syn/risk"})
    public ResponseData synRisk(@RequestBody List<AddSysCompanyRiskParam> paramList) {
        this.companyProviderService.synRiskFactor(paramList);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=40)
    @ApiOperation(value="\u53cd\u9988")
    @PostMapping(value={"/feedback"})
    public ResponseData feedback(@RequestBody SaveFeedbackParam param) {
        this.sysFeedbackProviderService.feedback(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=70)
    @ApiOperation(value="\u5355\u4f4d\u62a5\u540d-\u7ed9\u81ea\u8eab\u62a5\u540d")
    @PostMapping(value={"/selectTraining"})
    @RequestLimit(second=30, maxCount=1)
    public ResponseData selectTraining(@RequestBody CropSelectTraninglParam param) {
        param.setUserType(ShiroUtil.getUserType());
        this.enrollProviderService.enroll(param);
        return ResponseData.success((String)"\u62a5\u540d\u6210\u529f");
    }

    @ApiOperationSupport(order=70)
    @ApiOperation(value="\u5355\u4f4d\u62a5\u540d-\u4e8c\u7ef4\u7801\u52a0\u5bc6")
    @PostMapping(value={"/generateQRCodeContent"})
    public ResponseData generateQRCodeContent(@RequestBody GenerateEnrollQRCodeParam param) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.enrollProviderService.generateQRCodeContent(param));
    }

    @ApiOperationSupport(order=70)
    @ApiOperation(value="\u5355\u4f4d\u62a5\u540d-\u4e8c\u7ef4\u7801\u5386\u53f2\u5185\u5bb9\u83b7\u53d6")
    @PostMapping(value={"/getQRCodeContent"})
    public ResponseData<EnrollQRCodeVo> getQRCodeContent(@RequestBody GenerateEnrollQRCodeParam param) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.enrollProviderService.getQRCodeContent(param));
    }
}

