/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.HttpClientUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.UserLoginWeixin;
import cn.smarthse.radiationTraining.modules.sys.service.user.IUserLoginWeixinService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.properties.WxOpenProperties;
import cn.smarthse.radiationTraining.modules.www.controller.ControllerSupport;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.DubboReference;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mobile/applet"})
@Api(tags={"\u767b\u5f55-\u5c0f\u7a0b\u5e8f\u767b\u5f55"}, hidden=true)
public class WXappletMobileController
extends ControllerSupport {
    private final WxOpenProperties wxOpenProperties;
    @DubboReference
    private IUserLoginWeixinService userLoginWeixinService;

    @ApiOperation(value="2.\u8c03\u7528 auth.code2Session \u63a5\u53e3")
    @GetMapping(value={"auth_code2Session"})
    public ResponseData<String> auth_code2Session(HttpServletRequest request, HttpServletResponse response, String code, String encryptedData, String iv) {
        String headerToken = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isNotBlank((CharSequence)headerToken) && !JwtUtil.isTokenExpired((String)headerToken).booleanValue()) {
            this.logger.info("\u767b\u5f55-\u5c0f\u7a0b\u5e8f\u767b\u5f55-token\u672a\u8fc7\u671f\uff0c\u76f4\u63a5\u8fd4\u56detoken\uff01");
            return ResponseData.success((String)headerToken);
        }
        if (StrUtil.isBlank((CharSequence)code) || StrUtil.isBlank((CharSequence)encryptedData) || StrUtil.isBlank((CharSequence)iv)) {
            return ResponseData.fail((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u767b\u5f55\u5931\u8d25\uff01");
        }
        this.logger.debug("\u767b\u5f55-\u5c0f\u7a0b\u5e8f\u767b\u5f55-code\uff1a{}-encryptedData:{}-iv:{}", new Object[]{code, encryptedData, iv});
        String sessionKey = this.getSessionKey(code);
        if (StrUtil.isBlank((CharSequence)sessionKey)) {
            return ResponseData.fail((String)"\u672a\u83b7\u53d6\u5230sessionKey\uff0c\u767b\u5f55\u5931\u8d25\uff01");
        }
        JSONObject userInfo = this.getUserInfo(encryptedData, sessionKey, iv);
        if (userInfo == null) {
            return ResponseData.fail((String)"\u767b\u5f55\u6570\u636e\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.logger.debug(userInfo.toString());
        UserLoginWeixin userLoginWeixin = new UserLoginWeixin();
        userLoginWeixin.setOpenId((String)userInfo.get((Object)"openId"));
        userLoginWeixin.setUnionid((String)userInfo.get((Object)"unionId"));
        userLoginWeixin.setCountry((String)userInfo.get((Object)"country"));
        userLoginWeixin.setNickname((String)userInfo.get((Object)"nickName"));
        userLoginWeixin.setSex(((Integer)userInfo.get((Object)"gender")).toString());
        userLoginWeixin.setProvince((String)userInfo.get((Object)"province"));
        userLoginWeixin.setCity((String)userInfo.get((Object)"city"));
        userLoginWeixin.setHeadimgurl((String)userInfo.get((Object)"avatarUrl"));
        userLoginWeixin.setLanguage((String)userInfo.get((Object)"language"));
        SysUser user = this.userLoginWeixinService.saveUserLoginWeixin(userLoginWeixin);
        if (user == null) {
            return ResponseData.fail((String)"\u53c2\u6570\u9519\u8bef\uff0c\u767b\u5f55\u5931\u8d25\uff01");
        }
        response.setHeader("TOKEN", null);
        return ResponseData.success(null);
    }

    private String getSessionKey(String code) {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";
        url = String.format(url, this.wxOpenProperties.getApplet_app_id(), this.wxOpenProperties.getApplet_app_secret(), code);
        try {
            String result = HttpClientUtils.get((String)url);
            Gson gson = new Gson();
            Map resultMap = (Map)gson.fromJson(result, Map.class);
            return (String)resultMap.get("session_key");
        }
        catch (Exception e) {
            this.logger.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    private JSONObject getUserInfo(String encryptedData, String sessionkey, String iv) {
        byte[] dataByte = Base64.decode((CharSequence)encryptedData);
        byte[] keyByte = Base64.decode((CharSequence)sessionkey);
        byte[] ivByte = Base64.decode((CharSequence)iv);
        try {
            int base = 16;
            if (keyByte.length % base != 0) {
                int groups = keyByte.length / base + 1;
                byte[] temp = new byte[groups * base];
                Arrays.fill(temp, (byte)0);
                System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
                keyByte = temp;
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
            parameters.init(new IvParameterSpec(ivByte));
            cipher.init(2, (Key)spec, parameters);
            byte[] resultByte = cipher.doFinal(dataByte);
            if (null != resultByte && resultByte.length > 0) {
                String result = new String(resultByte, StandardCharsets.UTF_8);
                return JSONObject.parseObject((String)result);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.logger.error("Exception\uff1a", (Throwable)e);
        }
        return null;
    }

    public WXappletMobileController(WxOpenProperties wxOpenProperties) {
        this.wxOpenProperties = wxOpenProperties;
    }
}

