/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller;

import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.www.controller.ControllerSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u6ce8\u518c"})
@RestController
@RequestMapping(value={"/register"})
@Validated
public class UserRegisterController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private IUserCropProviderService userCropProviderService;

    @RequestLimit(second=60, maxCount=5)
    @ApiOperation(value="\u53d1\u9001\u6ce8\u518c\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    @ApiImplicitParam(name="email", value="\u90ae\u7bb1\u53f7", required=true, paramType="query", dataTypeClass=String.class)
    @GetMapping(value={"/code"})
    public ResponseData<Boolean> sendRegisterCode(@ApiParam(value="\u90ae\u7bb1\u53f7") @RequestParam String email) {
        if (!StringUtils.checkEmail((String)email)) {
            return ResponseData.fail((String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff01");
        }
        SysUser user = this.userProviderService.getOneByEmail(email);
        if (user != null) {
            return ResponseData.fail((String)"\u8be5\u90ae\u7bb1\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u6ce8\u518c\u4f7f\u7528\uff01", (Object)false);
        }
        return ResponseData.success((Object)this.loginService.sendRegisterEmailCode(email));
    }

    public UserRegisterController(LoginService loginService) {
        this.loginService = loginService;
    }
}

