/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.service;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterCompanyUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.info.IUserInfoProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.PermissionsService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.User;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @DubboReference
    private IUserProviderService userService;
    @DubboReference
    private IUserCropProviderService userCropService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IUserInfoProviderService userInfoProviderService;
    private final PermissionsService permissionsService;
    @Resource
    private RedisTemplate<String, ShiroPrincipal> redisTemplate;

    public void doGetAuthorizationInfo(ShiroPrincipal principal) {
        this.permissionsService.addRoleAndPerms(principal);
    }

    public ShiroPrincipal getLoginUser(Long userId) {
        if (userId == null) {
            return null;
        }
        String loginUserKey = RedisKey.getLoginUserKey((Long)userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            SysUser user = this.userService.selectUserById(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6388\u6743\u5931\u8d25\uff01");
            }
            principal.setUser(new User(user));
            if (Objects.equals(principal.getUserType(), SysUserTypeEnum.USER.getValue())) {
                principal.setUserInfo(this.userInfoProviderService.getUserInfo(principal.getUserId()));
            } else {
                HseCompanyVo vo = this.hseCompanyProviderService.getInfoById(Long.valueOf(user.getToken()));
                CompanyInfo companyInfo = new CompanyInfo();
                companyInfo.setId(vo.getId());
                companyInfo.setName(vo.getName());
                companyInfo.setCreditCode(vo.getUnifiedSocialCc());
                companyInfo.setContactTel(vo.getCompanyContactTel());
                companyInfo.setContact(vo.getOccManagerName());
                companyInfo.setAreaId(vo.getAreaId());
                companyInfo.setAreaAddress(vo.getRegisterAddress());
                companyInfo.setIndustryCode(String.valueOf(vo.getIndustryCategory()));
                companyInfo.setBelongType(vo.getBelongType());
                principal.setCompanyInfo(companyInfo);
            }
            this.permissionsService.addRoleAndPerms(principal);
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public SysUser registerByUsername(RegisterCompanyUserParam param) {
        return this.userCropService.registerByUsername(param);
    }

    public SysUser getByUsername(String username, SysUserTypeEnum userTypeEnum) {
        return this.userService.getUserByToken(username, userTypeEnum.getValue());
    }

    public SysUser getCompanyUserByToken(Long token) {
        return this.userService.getCompanyUserByToken(token);
    }

    public void updateById(SysUser user) {
        this.userCropService.updateById(user);
    }

    public CompanyInfo getCompanyByUserId(Long userId) {
        return this.userCropService.getCompanyByUserId(userId);
    }

    public TokenService(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }
}

