/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysRole;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysPermService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysRoleService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.ShiroPrincipal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService {
    @DubboReference
    private ISysPermService permService;
    @DubboReference
    private ISysRoleService roleService;

    public List<SysRole> selectRoleList(Long userId) {
        return this.roleService.selectRoleList(userId);
    }

    public boolean addRole(Long userId, Long ... roleIds) {
        return this.roleService.addRole(userId, roleIds);
    }

    public Set<String> selectPermSetByRoleIds(Set<Long> roleIds) {
        return this.permService.selectPermSetByRoleIds(roleIds);
    }

    public void addRoleAndPerms(ShiroPrincipal loginUser) {
        List<SysRole> sysRoles = this.selectRoleList(loginUser.getUser().getId());
        if (CollUtil.isEmpty(sysRoles)) {
            loginUser.setRoleSet(Collections.emptySet());
            loginUser.setPermissionsSet(Collections.emptySet());
            return;
        }
        loginUser.setRoleSet(sysRoles.stream().map(SysRole::getSrKey).collect(Collectors.toSet()));
        Set<Long> roleIds = sysRoles.stream().map(SysRole::getId).collect(Collectors.toSet());
        loginUser.setPermissionsSet(this.selectPermSetByRoleIds(roleIds));
    }
}

