/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.realms;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterCompanyUserParam;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.User;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class CasRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(CasRealm.class);
    @Autowired
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof CasToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        CasToken token = (CasToken)authenticationToken;
        log.info("{} - cas auth start...", (Object)token.getUsername());
        RegisterCompanyUserParam param = new RegisterCompanyUserParam();
        param.setUserType(token.getUserType());
        param.setUsername(token.getUsername());
        param.setCompanyName(token.getName());
        param.setCreditCode(token.getCreditCode());
        param.setAreaId(token.getAreaId());
        param.setIndustryCode(token.getIndustryCode());
        param.setContactNumber(token.getContactTel());
        param.setEmail(token.getEmail());
        param.setToken(token.getToken());
        param.setIsTest(token.getIsTest());
        param.setSuperviseIsHide(token.getSuperviseIsHide());
        param.setBelongType(token.getBelongType());
        param.setBusinessState(token.getBusinessState());
        SysUser user = this.tokenService.registerByUsername(param);
        if (user.getIsForbidden() == Constant.YES) {
            throw new DisabledAccountException();
        }
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(new User(user)), (Object)"", super.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

