/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.urgency;

import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.training.param.course.UpTuCourseRedundencyParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=10, author="\u9648\u4eae")
@Api(tags={"\u7d27\u6025\u5904\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/urgency"})
public class UrgencyController
extends ControllerSupport {
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ITuCourseProviderService tuCourseProviderService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u91cd\u65b0\u5efa\u7acb\u516c\u53f8\u5458\u5de5\u5173\u7cfb")
    @GetMapping(value={"reBuildAllRelationship"})
    public ResponseData getTrainingList(String pwd) {
        this.enrollProviderService.reBuildAllRelationship(pwd);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u5206\u6790\u516c\u53f8\u5bf9\u5e94\u7684\u804c\u4e1a\u5065\u5eb7\u5458\u57f9\u8bad\u72b6\u6001")
    @GetMapping(value={"analyseHSEComapnyTrain"})
    public ResponseData analyseHSEComapnyTrain(String pwd) {
        if (!pwd.equals("zhzhhbkjyxgs155fff89")) {
            throw new ServiceException("\u64cd\u4f5c\u9519\u8bef");
        }
        return ResponseData.success((Object)this.enrollProviderService.analyseHSEComapnyTrain());
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u540c\u6b65\u516c\u53f8\u57f9\u8bad\u72b6\u6001\u5230\u804c\u4e1a\u5065\u5eb7")
    @GetMapping(value={"syncHSECompanyTrainStatus"})
    public ResponseData syncHSECompanyTrainStatus(String pwd) {
        if (!pwd.equals("zhzhhbkjyxgs155fff89")) {
            throw new ServiceException("\u64cd\u4f5c\u9519\u8bef");
        }
        String s = this.enrollProviderService.syncHSECompanyTrainStatus();
        return ResponseData.success((String)s);
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:view"})
    @ApiOperation(value="\u83b7\u53d6\u804c\u4e1a\u5065\u5eb7\u516c\u53f8\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"getCompanyOtherInfo"})
    public ResponseData getCompanyOtherInfo(Long cid) {
        List industryCodesByCid = this.hseCompanyProviderService.getIndustryCodesByCid(cid);
        List riskFactorByCid = this.hseCompanyProviderService.getRiskFactorByCid(cid);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("\u884c\u4e1a", industryCodesByCid);
        result.put("\u5371\u5bb3\u56e0\u6570", riskFactorByCid);
        return ResponseData.success(result);
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u66f4\u65b0\u5b66\u4e60\u8bb0\u5f55\u5197\u4f59\u6570\u636e")
    @PostMapping(value={"updateTuCourseRedundency"})
    public ResponseData updateTuCourseRedundency(@RequestBody UpTuCourseRedundencyParam param) {
        this.tuCourseProviderService.updateRedundency(param.getTid(), param.getCourseItemId());
        return ResponseData.success((String)"\u6210\u529f");
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u6e05\u9664\u6240\u6709tuCoruseId\u7f13\u5b58")
    @PostMapping(value={"cleanAllTuCoruseIdCache"})
    public ResponseData cleanOldTuCoruseIdCache() {
        this.redisUtil.delete("TUCOURSE:ID");
        return ResponseData.success((String)"\u6210\u529f");
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u6e05\u9664\u6240\u6709tuCoruse\u7f13\u5b58")
    @PostMapping(value={"cleanAllTuCoruseCache"})
    public ResponseData cleanOldTuCoruseIdCache(String psw) {
        if (!psw.equals("sdfsdf18918sdf")) {
            throw new ServiceException("\u4e8c\u7ea7\u5bc6\u7801\u9519\u8bef");
        }
        this.redisUtil.delete("TUCOURSE:CACHE");
        return ResponseData.success((String)"\u6210\u529f");
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u6e05\u9664\u6240\u6709\u57fa\u7840\u76ee\u5f55\u7f13\u5b58")
    @PostMapping(value={"cleanAllBasicDirectoryCache"})
    public ResponseData cleanAllBasicDirectoryCache() {
        this.redisUtil.delete(RedisKey.getCatalogue(null));
        return ResponseData.success((String)"\u6210\u529f");
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u6e05\u9664\u6240\u6709\u8bfe\u7a0b\u7f13\u5b58")
    @PostMapping(value={"cleanAllCourseItemCache"})
    public ResponseData cleanAllCourseItemCache(String psw) {
        this.redisUtil.delete(RedisKey.getCourseItemVo(null));
        return ResponseData.success((String)"\u6210\u529f");
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u901a\u7528\u6d4b\u8bd5")
    @PostMapping(value={"test"})
    public ResponseData test(Long trainAreaId, Long cAreaId) {
        AreaDto trainArea = this.areaProviderService.getAreaById(trainAreaId);
        AreaDto companyArea = this.areaProviderService.getAreaById(cAreaId);
        if (trainArea.getLevel() > companyArea.getLevel()) {
            throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
        if (trainArea.getLevel() == 1) {
            return ResponseData.success((String)"level 1\u6210\u529f");
        }
        if (trainArea.getLevel() == 2) {
            if (!trainArea.getCityId().equals(companyArea.getCityId())) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
        } else if (trainArea.getLevel() == 3) {
            if (!trainArea.getAreaId().equals(companyArea.getAreaId())) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
        } else if (trainArea.getLevel() == 4) {
            if (!trainArea.getStreetId().equals(companyArea.getStreetId())) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
        } else {
            throw new ServiceException("\u533a\u57df\u6821\u9a8c\u5931\u8d25");
        }
        return ResponseData.success((String)"\u5168\u90e8\u6210\u529f");
    }
}

