/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.training;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.param.training.AddNewTrainCourseGroupParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=10, author="\u891a\u6d77\u6d0b")
@Api(tags={"\u57f9\u8bad\u7ba1\u7406-(\u8bfe\u7a0b\u3001\u8bfe\u7a0b\u7ec4)\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/trainingManage/course"})
public class TrainingCourseController
extends ControllerSupport {
    @DubboReference
    private ITrainingCourseProviderService iTrainingCourseProviderService;

    @RequiresPermissions(value={"training:view"})
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad-\u8bfe\u7a0b\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"getNewTrainCourse"})
    public ResponseData<LayuiGridData<TrainingNewCourseGroupVo>> getNewTrainCourse(TrainingSearchParam param) {
        return new ResponseData((Object)this.iTrainingCourseProviderService.getNewTrainCourse(param));
    }

    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u63d0\u4ea4\u57f9\u8bad-\u8bfe\u7a0b\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"saveOrUpdateNewTrainCourse"})
    public ResponseData<String> saveOrUpdateNewTrainCourse(@RequestBody AddNewTrainCourseGroupParam param) {
        this.iTrainingCourseProviderService.saveOrUpdateNewTrainCourse(param);
        return ResponseData.success();
    }

    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u8fd4\u56de\u65b0\u7684\u8bfe\u7a0b\u4fe1\u606f")
    @GetMapping(value={"getNewCourseInfo"})
    public ResponseData<CourseItemVo> getNewCourseInfo(Long courseId) {
        return ResponseData.success((Object)this.iTrainingCourseProviderService.getNewCourseInfo(courseId));
    }

    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u5220\u9664\u57f9\u8bad\u8bfe\u7a0b\u7f13\u5b58")
    @GetMapping(value={"delTrainCourseRedis"})
    public ResponseData<String> delTrainCourseRedis() {
        return ResponseData.success((String)this.iTrainingCourseProviderService.delTrainCourseRedis());
    }

    @RequiresPermissions(value={"training:edit"})
    @ApiOperation(value="\u5c06\u8bfe\u7a0b\u7ec4\u8001\u6570\u636e\u6dfb\u52a0\u81f3\u5197\u4f59\u6570\u636e\u4e2d")
    @GetMapping(value={"modifyOldTrainCourseGroup"})
    public ResponseData<String> modifyOldTrainCourseGroup() {
        return ResponseData.success((String)this.iTrainingCourseProviderService.modifyOldTrainCourseGroup());
    }
}

