/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.param.admin.ForbiddenUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.QueryUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpRedundancyInfoParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.SysUserTrainInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainEnrollCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=60, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u4e2a\u4eba\u8d26\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController
extends ControllerSupport {
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysCompanyStaffProviderService sysCompanyStaffProviderService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser trainingProviderServiceForUser;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u5217\u8868")
    @GetMapping(value={"getUserList"})
    @RequiresPermissions(value={"sys:user:user:view"})
    public ResponseData<LayuiGridData<UserListVo>> getUserList(QueryUserParam param) {
        param.setAreaId(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        Integer zero = 0;
        Integer isTest = param.getIsTest() == null ? (ShiroUtil.isSpecifiedUser() ? param.getIsTest() : zero) : param.getIsTest();
        param.setIsTest(isTest);
        return new ResponseData((Object)this.userProviderService.getUserList(param));
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u8d26\u53f7id", dataTypeClass=Long.class)})
    @GetMapping(value={"getUser"})
    @RequiresPermissions(value={"sys:user:user:view"})
    public ResponseData<UserVo> getUser(Long userId) {
        return new ResponseData((Object)this.userProviderService.getUserVo(userId));
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u7f16\u8f91\u3001\u6dfb\u52a0")
    @PostMapping(value={"saveUser"})
    @RequiresPermissions(value={"sys:user:user:edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7\u7ba1\u7406", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt)
    public ResponseData<String> saveUser(@RequestBody SaveUserParam param) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(param.getId());
        this.userProviderService.ifCanEditPersonalUserBatch(list, ShiroUtil.getLoginUsername(), ShiroUtil.getUserInfo().getUserFrom(), ShiroUtil.getUserInfo().getOperationRole(), ShiroUtil.getUserInfo().getAreaId());
        this.userProviderService.saveUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u5220\u9664")
    @PostMapping(value={"del"})
    @RequiresPermissions(value={"sys:user:user:edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdsParam param) {
        UserInfo user = ShiroUtil.getShiroPrincipal().getUser();
        this.userProviderService.ifCanRmForPersonal(param.getIdList(), ShiroUtil.getLoginUsername(), user.getUserFrom(), user.getOperationRole());
        this.userProviderService.del(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528")
    @PostMapping(value={"forbiddenAdmin"})
    @RequiresPermissions(value={"sys:user:user:edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenUserParam param) {
        this.userProviderService.ifCanEditPersonalUserBatch(param.getIdList(), ShiroUtil.getLoginUsername(), ShiroUtil.getUserInfo().getUserFrom(), ShiroUtil.getUserInfo().getOperationRole(), ShiroUtil.getUserInfo().getAreaId());
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"resetPassword"})
    @RequiresPermissions(value={"sys:user:user:edit"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u91cd\u7f6e\u5bc6\u7801", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_reset)
    public ResponseData<String> resetPassword(@RequestBody IdsParam param) {
        this.userProviderService.ifCanEditPersonalUserBatch(param.getIdList(), ShiroUtil.getLoginUsername(), ShiroUtil.getUserInfo().getUserFrom(), ShiroUtil.getUserInfo().getOperationRole(), ShiroUtil.getUserInfo().getAreaId());
        this.userProviderService.resetPassword(param.getIdList(), param.getLoginUserId());
        return ResponseData.success((String)String.format("\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\u4e3a\u201c%s\u201d\uff01", "Zyj@2022"));
    }

    @ApiOperation(value="\u4e2a\u4eba\u7528\u6237\u8be6\u60c5-\u67e5\u770b\u57f9\u8bad\u5217\u8868")
    @GetMapping(value={"getTrainingList"})
    @RequiresPermissions(value={"sys:user:user:view"})
    public ResponseData<LayuiGridData<TrainingPersonEnrollVo>> getTrainingList(PersonEnrollSearchParam param) {
        param.setAreaId(ShiroUtil.getLoginAreaId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.trainingProviderServiceForUser.listPersnoEnroll(param));
    }

    @ApiOperation(value="\u67e5\u770b\u4e2a\u4eba\u7528\u6237\u8be6\u60c5-\u57f9\u8bad\u57fa\u672c\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId"), @ApiImplicitParam(name="uid", value="\u7528\u6237Id"), @ApiImplicitParam(name="enrollDetailId", value="\u7528\u6237\u62a5\u540dId")})
    @GetMapping(value={"getMyTrainingBaseInfo"})
    @RequiresPermissions(value={"sys:user:user:view"})
    public ResponseData<SysUserTrainInfoVo> getMyTrainingBaseInfo(Long tid, Long uid, Long enrollDetailId) {
        return new ResponseData((Object)this.trainingProviderServiceForUser.getMyTrainingBaseInfoForUser(tid, uid, enrollDetailId));
    }

    @ApiOperation(value="\u4e2a\u4eba\u7528\u6237\u8be6\u60c5-\u67e5\u770b\u57f9\u8bad\u8bfe\u7a0b\u5217\u8868")
    @GetMapping(value={"getEnrollDetailList"})
    @RequiresPermissions(value={"sys:user:user:view"})
    public ResponseData<LayuiGridData<TrainEnrollCourseVo>> getEnrollDetailList(PersonEnrollCourseParam param) {
        return new ResponseData((Object)this.trainingProviderServiceForUser.listPersnoEnrollCourse(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u57f9\u8bad\u7684\u5de5\u4f5c\u7c7b\u522b")
    @GetMapping(value={"getTrainingWorkType"})
    @RequiresPermissions(value={"sys:user:user:view"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType(Long uid) {
        return new ResponseData((Object)this.trainingProviderServiceForUser.getTrainingWorkType(uid));
    }

    @ApiOperation(value="\u4fee\u6539\u8eab\u4efd\u8bc1\u5197\u4f59\u4fe1\u606f")
    @PostMapping(value={"upRedundencyInfo", "updateRedundancyExcludeUintInfo"})
    @RequiresPermissions(value={"sys:user:user:edit"})
    public ResponseData<String> updateRedundancyExcludeUintInfo(@RequestBody UpRedundancyInfoParam param) {
        this.tuEnrollProviderService.updateRedundancyExcludeUintInfo(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4fee\u6539\u5355\u4f4d\u5197\u4f59\u4fe1\u606f")
    @PostMapping(value={"updateUnitRedundancyInfo"})
    @RequiresPermissions(value={"sys:user:user:edit"})
    public ResponseData<String> updateUnitRedundancyInfo(@RequestBody UpRedundancyInfoParam param) {
        this.tuEnrollProviderService.updateUnitRedundancyInfo(param);
        return ResponseData.success();
    }
}

