/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.user;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.param.admin.AddAdminParam;
import cn.smarthse.radiationTraining.modules.sys.param.admin.ForbiddenUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.admin.SaveAdminParam;
import cn.smarthse.radiationTraining.modules.sys.provider.admin.IAdminProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.admin.AdminListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.admin.AdminVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=61, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u540e\u53f0\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/admin"})
public class AdminController
extends ControllerSupport {
    @DubboReference
    private IAdminProviderService adminProviderService;

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u5217\u8868")
    @GetMapping(value={"getUserList"})
    @RequiresPermissions(value={"sys:user:admin:view"})
    public ResponseData<LayuiGridData<AdminListVo>> getUserList(PageParam param) {
        return new ResponseData((Object)this.adminProviderService.getUserList(param));
    }

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u8d26\u53f7id", dataTypeClass=Long.class)})
    @GetMapping(value={"getUser"})
    @RequiresPermissions(value={"sys:user:admin:view"})
    public ResponseData<AdminVo> getUser(Long userId) {
        return new ResponseData((Object)this.adminProviderService.getUser(userId));
    }

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u7f16\u8f91")
    @PostMapping(value={"saveUser"})
    @RequiresPermissions(value={"sys:user:admin:edit"})
    @Log(title="\u7f16\u8f91\u540e\u53f0\u7528\u6237", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveUser(@RequestBody SaveAdminParam param) {
        this.adminProviderService.saveUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u65b0\u589e")
    @PostMapping(value={"addUser"})
    @RequiresPermissions(value={"sys:user:admin:edit"})
    @Log(title="\u540e\u53f0\u7528\u6237-\u65b0\u589e", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> addUser(@RequestBody AddAdminParam param) {
        this.adminProviderService.addUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u5220\u9664")
    @PostMapping(value={"del"})
    @RequiresPermissions(value={"sys:user:admin:edit"})
    @Log(title="\u540e\u53f0\u7528\u6237-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdParam param) {
        this.adminProviderService.del(param.getId(), param.getLoginUserId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u7981\u7528\u3001\u542f\u7528")
    @PostMapping(value={"forbiddenAdmin"})
    @RequiresPermissions(value={"sys:user:admin:edit"})
    @Log(title="\u540e\u53f0\u7528\u6237-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenUserParam param) {
        this.adminProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u540e\u53f0\u7528\u6237-\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"resetPassword"})
    @RequiresPermissions(value={"sys:user:admin:edit"})
    @Log(title="\u540e\u53f0\u7528\u6237-\u91cd\u7f6e\u5bc6\u7801", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_reset)
    public ResponseData<String> resetPassword(@RequestBody IdsParam param) {
        this.adminProviderService.resetPassword(param);
        return ResponseData.success((String)"\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\u4e3a\u201c%s\u201d\uff01", (Object)"Zjs@2022");
    }
}

