/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.role;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.param.admin.SaveRoleParam;
import cn.smarthse.radiationTraining.modules.sys.provider.admin.IAdminRoleProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.admin.IAdminSecPermService;
import cn.smarthse.radiationTraining.modules.sys.vo.role.SecPermVo;
import cn.smarthse.radiationTraining.modules.sys.vo.role.SecRoleListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.role.SecRolePermVo;
import cn.smarthse.radiationTraining.modules.sys.vo.role.SecRoleSimpleVo;
import cn.smarthse.radiationTraining.modules.sys.vo.role.SecRoleVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=63, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u89d2\u8272\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/role"})
public class RoleController
extends ControllerSupport {
    @DubboReference
    private IAdminRoleProviderService adminRoleProviderService;
    @DubboReference
    IAdminSecPermService adminSecPermService;

    @ApiOperation(value="\u89d2\u8272-\u5217\u8868")
    @RequiresPermissions(value={"sys:role:view"})
    @GetMapping(value={"getRoleList"})
    public ResponseData<LayuiGridData<SecRoleListVo>> getRoleList(PageParam param) {
        return ResponseData.success((Object)this.adminRoleProviderService.getRoleList(param));
    }

    @ApiOperation(value="\u89d2\u8272-\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u89d2\u8272id", dataTypeClass=Long.class)})
    @RequiresPermissions(value={"sys:role:view"})
    @GetMapping(value={"getRole"})
    public ResponseData<SecRoleVo> getRole(Long id) {
        return ResponseData.success((Object)this.adminRoleProviderService.getRole(id));
    }

    @ApiOperation(value="\u89d2\u8272-\u7f16\u8f91\u3001\u65b0\u589e")
    @PostMapping(value={"saveRole"})
    @RequiresPermissions(value={"sys:role:edit"})
    @Log(title="\u89d2\u8272-\u7f16\u8f91\u3001\u65b0\u589e", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveRole(@RequestBody SaveRoleParam param) {
        this.adminRoleProviderService.saveRole(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u89d2\u8272-\u5220\u9664")
    @PostMapping(value={"del"})
    @RequiresPermissions(value={"sys:role:edit"})
    @Log(title="\u89d2\u8272-\u5220\u9664", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> del(@RequestBody IdParam param) {
        this.adminRoleProviderService.del(param.getId(), param.getLoginUserId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u9009\u89d2\u8272")
    @GetMapping(value={"getChooseRoleList"})
    public ResponseData<List<SecRoleSimpleVo>> getChooseRoleList() {
        return ResponseData.success((Object)this.adminRoleProviderService.getChooseRoleList());
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u9009\u6743\u9650")
    @GetMapping(value={"getChoosePermissionList"})
    public ResponseData<List<SecRolePermVo>> getChoosePermissionList() {
        return ResponseData.success((Object)this.adminRoleProviderService.getChoosePermissionList(ShiroUtil.getRoleSet()));
    }

    @ApiOperation(value="\u6743\u9650\u5217\u8868")
    @GetMapping(value={"getPermissionList"})
    public ResponseData<List<SecPermVo>> getAllPermissionList() {
        return ResponseData.success((Object)this.adminSecPermService.getAllPermissionTree());
    }
}

