/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.sys.company;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.param.sys.QueryFeedBackParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.QueryCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.SaveCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFeedbackProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.info.ICompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFeedBackVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.RhoCompanyListVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ApiSupport(order=62, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u7ba1\u7406-\u5355\u4f4d\u5e95\u5e93"})
@Controller
@RequestMapping(value={"/sys/company"})
public class SysCompanyController
extends ControllerSupport {
    @DubboReference
    private ICompanyProviderService companyProviderService;
    @DubboReference
    private ISysFeedbackProviderService sysFeedbackProviderService;

    @ApiOperation(value="\u5355\u4f4d\u5e95\u5e93-\u5217\u8868")
    @GetMapping(value={"getCompanyList"})
    @ResponseBody
    @RequiresPermissions(value={"sys:view"})
    public ResponseData<LayuiGridData<CompanyListVo>> getCompanyList(QueryCompanyParam param) {
        return new ResponseData((Object)this.companyProviderService.getCompanyList(param));
    }

    @ApiOperation(value="\u5355\u4f4d\u5e95\u5e93-\u5355\u4f4d\u5e95\u5e93\u53cd\u9988\u5217\u8868")
    @GetMapping(value={"getFeedBackList"})
    @ResponseBody
    public ResponseData<LayuiGridData<SysFeedBackVo>> getFeedBackList(QueryFeedBackParam param) {
        return new ResponseData((Object)this.sysFeedbackProviderService.getFeedBackList(param));
    }

    @ApiOperation(value="\u5355\u4f4d\u5e95\u5e93-\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5355\u4f4d\u5e95\u5e93id")})
    @GetMapping(value={"getCompany"})
    @ResponseBody
    public ResponseData<CompanyVo> getCompany(Long id) {
        return new ResponseData((Object)this.companyProviderService.getCompany(id));
    }

    @ApiOperation(value="\u5355\u4f4d\u5e95\u5e93-\u7f16\u8f91")
    @PostMapping(value={"saveUser"})
    @ResponseBody
    @RequiresPermissions(value={"sys:user:crop:edit"})
    @Log(title="\u5355\u4f4d\u5e95\u5e93-\u7f16\u8f91", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> saveUser(@RequestBody SaveCompanyParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name", "creditCode", "areaId"});
        this.companyProviderService.saveUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u533b\u9662\u5355\u4f4d\u5e95\u5e93-\u5217\u8868")
    @GetMapping(value={"getCompanyListForRho"})
    @ResponseBody
    @RequiresPermissions(value={"sys:view"})
    public ResponseData<LayuiGridData<RhoCompanyListVo>> getCompanyListForRho(QueryCompanyParam param) {
        return new ResponseData((Object)this.companyProviderService.getCompanyListForRho(param));
    }
}

