/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.questionManage;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.admin.service.easyexcel.QuestionImportListener;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSetBatchParam;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionData;
import cn.smarthse.radiationTraining.modules.question.provider.IQuestionProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.QuestionVo;
import cn.smarthse.radiationTraining.modules.question.vo.SpecialQuestionStatisticsVo;
import cn.smarthse.radiationTraining.modules.training.param.course.CoursePageParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseItemManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ApiSupport(order=30, author="\u5434\u5c0f\u5f3a")
@Api(tags={"\u8bd5\u9898\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/questionManage"})
public class QuestionController
extends ControllerSupport {
    private final String info_prefix = "[\u8bd5\u9898\u7ba1\u7406]";
    @DubboReference
    private IQuestionProviderService questionProviderService;
    @DubboReference(check=false)
    private ICourseItemManagerProviderService courseItemManagerService;

    @RequiresPermissions(value={"question:item:view"})
    @ApiOperation(value="\u8bd5\u9898\u5217\u8868")
    @GetMapping(value={"getQuestionList"})
    public ResponseData<LayuiGridData<QuestionVo>> getUserList(QuestionSearchParam param) {
        param.setUid(ShiroUtil.getLoginUserId());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        return new ResponseData((Object)this.questionProviderService.getQuestionList(param));
    }

    @RequiresPermissions(value={"question:item:view"})
    @ApiOperation(value="\u67e5\u770b\u8bd5\u9898\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="questionId", value="\u8bd5\u9898id")})
    @GetMapping(value={"getQuestionDetail"})
    public ResponseData<QuestionVo> getQuestionDetail(Long questionId) {
        this.logger.debug("{}-\u67e5\u770b\u8bd5\u9898\u8be6\u60c5\uff1aquestionId-{}", (Object)"[\u8bd5\u9898\u7ba1\u7406]", (Object)questionId);
        return ResponseData.success((Object)this.questionProviderService.getQuestionDetailById(questionId));
    }

    @RequiresPermissions(value={"question:item:edit"})
    @ApiOperation(value="\u65b0\u589e\u8bd5\u9898")
    @Log(title="\u65b0\u589e\u8bd5\u9898", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"/add"})
    @ResponseBody
    public ResponseData<String> add(@RequestBody QuestionVo question) {
        question.setCreateBy(ShiroUtil.getLoginUserId());
        question.setUpdateBy(ShiroUtil.getLoginUserId());
        question.setCreateName(ShiroUtil.getUserInfo().getUsername());
        question.setUpdateName(ShiroUtil.getUserInfo().getUsername());
        this.questionProviderService.addQuestion(question);
        return ResponseData.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:item:edit"})
    @ApiOperation(value="\u66f4\u65b0\u8bd5\u9898")
    @Log(title="\u66f4\u65b0\u8bd5\u9898", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResponseData<String> update(@RequestBody QuestionVo question) {
        question.setUpdateBy(ShiroUtil.getLoginUserId());
        question.setUpdateName(ShiroUtil.getUserInfo().getUsername());
        question.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        this.questionProviderService.updateQuestion(question);
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:item:edit"})
    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e \u5371\u5bb3\u56e0\u7d20\u3001\u884c\u4e1a\u3001\u8bfe\u7a0b")
    @PostMapping(value={"/setBatch"})
    @ResponseBody
    public ResponseData<String> setBatch(@RequestBody QuestionSetBatchParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIds())) {
            return ResponseData.fail((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        param.setUpdateBy(ShiroUtil.getLoginUserId());
        param.setUpdateName(ShiroUtil.getUserInfo().getUsername());
        param.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        this.logger.debug("{}-\u6279\u91cf\u8bbe\u7f6e \u5371\u5bb3\u56e0\u7d20\u3001\u884c\u4e1a\u3001\u8bfe\u7a0b\uff1aids-{}", (Object)"[\u8bd5\u9898\u7ba1\u7406]", (Object)param.getIds().size());
        this.questionProviderService.setBatch(param);
        return ResponseData.success((String)"\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:item:edit"})
    @ApiOperation(value="\u5220\u9664\u3001\u6279\u91cf\u5220\u9664")
    @Log(title="\u5220\u9664\u8bd5\u9898", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"/del"})
    @ResponseBody
    public ResponseData<String> delete(@RequestBody IdsParam ids) {
        this.logger.debug("{}-\u5220\u9664\u3001\u6279\u91cf\u5220\u9664\uff1aids-{}", (Object)"[\u8bd5\u9898\u7ba1\u7406]", (Object)ids);
        ids.setUpdateBy(ShiroUtil.getLoginUserId());
        ids.setIsSpecifiedUser(Boolean.valueOf(ShiroUtil.isSpecifiedUser()));
        this.questionProviderService.deleteBatch(ids);
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"question:item:view"})
    @ApiOperation(value="\u9002\u7528\u8bfe\u7a0b-\u67e5\u8be2")
    @GetMapping(value={"/courseChooseData"})
    public ResponseData<LayuiGridData<CourseItemVo>> searchItemsByKeyword(CoursePageParam param) {
        param.setStatus(Integer.valueOf(1));
        LayuiGridData layuiGridData = this.courseItemManagerService.searchItemsByKeyword(param);
        return new ResponseData((Object)layuiGridData);
    }

    @RequiresPermissions(value={"question:item:edit"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165")
    @PostMapping(value={"/questionsImport"}, consumes={"multipart/form-data"})
    public ResponseData<String> questionsImport(@RequestPart(value="file") MultipartFile file) {
        this.logger.debug("{}-\u5355\u9009\u6279\u91cf\u5bfc\u5165", (Object)"[\u8bd5\u9898\u7ba1\u7406]");
        QuestionImportListener readListener = new QuestionImportListener(this.questionProviderService);
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ImportQuestionData.class, (ReadListener)readListener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (IOException e) {
            this.logger.error("IOException\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return new ResponseData(ResponseStateEnum.success, "\u5bfc\u5165\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:item:view"})
    @ApiOperation(value="\u6839\u636ecode\u7edf\u8ba1\u4e13\u7528\u9898\u5e93\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="code"), @ApiImplicitParam(name="type", value="\u7c7b\u578b(1-\u884c\u4e1a; 2-\u5371\u5bb3\u56e0\u7d20; 3-\u4eba\u5458\u7c7b\u578b;4-\u8bfe\u7a0b)")})
    @GetMapping(value={"/getSpecialQuestionNum"})
    public ResponseData<SpecialQuestionStatisticsVo> getSpecialQuestionNum(String code, Integer type) {
        return new ResponseData((Object)this.questionProviderService.getSpecialQuestionNum(code, type));
    }
}

