/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.questionManage;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureParam;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureSearchParam;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=30, author="\u5434\u5c0f\u5f3a")
@Api(tags={"\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/paperStructureManage"})
public class PaperStructureController
extends ControllerSupport {
    private final String info_prefix = "[\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406]";
    @DubboReference
    private IPaperStructureProviderService paperStructureProviderService;

    @RequiresPermissions(value={"question:structure:view"})
    @ApiOperation(value="\u8bd5\u5377\u7ed3\u6784\u5217\u8868")
    @GetMapping(value={"getList"})
    public ResponseData<LayuiGridData<PaperStructureVo>> getList(PaperStructureSearchParam param) {
        if (!ShiroUtil.isSpecifiedUser()) {
            param.setIsSpecial(Integer.valueOf(1));
        }
        return new ResponseData((Object)this.paperStructureProviderService.getPaperStructureList(param));
    }

    @RequiresPermissions(value={"question:structure:view"})
    @ApiOperation(value="\u67e5\u770b\u8bd5\u5377\u7ed3\u6784\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bd5\u5377\u7ed3\u6784id")})
    @GetMapping(value={"getPaperStructureDetail"})
    public ResponseData<PaperStructure> getQuestionDetail(Long id) {
        this.logger.debug("{}-\u67e5\u770b\u8bd5\u5377\u7ed3\u6784\u8be6\u60c5\uff1aid-{}", (Object)"[\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406]", (Object)id);
        return ResponseData.success((Object)this.paperStructureProviderService.getPaperStructureDetailById(id));
    }

    @RequiresPermissions(value={"question:structure:edit"})
    @ApiOperation(value="\u65b0\u589e\u8bd5\u5377\u7ed3\u6784")
    @PostMapping(value={"/add"})
    @ResponseBody
    @Log(title="\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406-\u65b0\u589e", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_add)
    public ResponseData<String> add(@RequestBody PaperStructure paperStructure) {
        this.logger.debug("{}-\u65b0\u589e\u8bd5\u5377\u7ed3\u6784", (Object)"[\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406]");
        paperStructure.setCreateBy(ShiroUtil.getLoginUserId());
        paperStructure.setUpdateBy(ShiroUtil.getLoginUserId());
        this.paperStructureProviderService.addPaperStructure(paperStructure);
        return ResponseData.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:structure:edit"})
    @ApiOperation(value="\u66f4\u65b0\u8bd5\u5377\u7ed3\u6784")
    @PostMapping(value={"/update"})
    @ResponseBody
    @Log(title="\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406-\u7f16\u8f91", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> update(@RequestBody PaperStructure paperStructure) {
        this.logger.debug("{}-\u66f4\u65b0\u8bd5\u5377\u7ed3\u6784\uff1aid-{}", (Object)"[\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406]", (Object)paperStructure.getId());
        paperStructure.setUpdateBy(ShiroUtil.getLoginUserId());
        this.paperStructureProviderService.updatePaperStructure(paperStructure);
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:structure:edit"})
    @ApiOperation(value="\u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/updateStatus"})
    @ResponseBody
    @Log(title="\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406-\u4fee\u6539\u542f\u7528\u72b6\u6001", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> updateStatus(@RequestBody PaperStructureParam param) {
        this.logger.debug("{}-\u542f\u7528/\u7981\u7528\uff1aid-{}\uff0cstatus-{}", new Object[]{"[\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406]", param.getId(), param.getStatus()});
        boolean result = this.paperStructureProviderService.updateStatus(param.getId(), param.getStatus());
        if (!result) {
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:structure:edit"})
    @ApiOperation(value="\u66f4\u65b0\u662f\u5426\u53ef\u89c1")
    @PostMapping(value={"/updateIsSpecial"})
    @ResponseBody
    @Log(title="\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406-\u4fee\u6539\u53ef\u89c1\u72b6\u6001", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> updateIsSpecial(@RequestBody PaperStructureParam param) {
        boolean result = this.paperStructureProviderService.updateIsSpecial(param);
        if (!result) {
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"question:structure:edit"})
    @ApiOperation(value="\u5220\u9664\u3001\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/del"})
    @ResponseBody
    @Log(title="\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406-\u5220\u9664", logModule=LogModuleTypeEnum.question, type=LogTypeEnum.type_opt_del)
    public ResponseData<String> delete(@RequestBody IdsParam ids) {
        this.logger.debug("{}-\u5220\u9664\u3001\u6279\u91cf\u5220\u9664\uff1aids-{}", (Object)"[\u8bd5\u5377\u7ed3\u6784\u7ba1\u7406]", (Object)ids);
        this.paperStructureProviderService.deleteBatch(ids);
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

