/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.course;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.param.course.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.ClassHourStatisticsParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemEditFullInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemSingleOptParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.course.KeyCourseAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.MatchCourseParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseItemManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.ClassHourstatisticsVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=20, author="\u9648\u4eae")
@Api(tags={"\u8bfe\u7a0b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/course/item"})
public class CourseItemController
extends ControllerSupport {
    @DubboReference(check=false)
    private ICourseItemManagerProviderService courseItemManagerService;

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u8bfe\u7a0b-\u67e5\u8be2\u6781\u7b80\u57f9\u8bad\u8bfe\u7a0b\u5217\u8868")
    @GetMapping(value={"/getPreciseCourseByTid"})
    public ResponseData<LayuiGridData<CourseItemVo>> getPreciseCourseByTid(CoursePageParam param) {
        LayuiGridData layuiGridData = this.courseItemManagerService.getPreciseCourseByTid(param);
        return new ResponseData((Object)layuiGridData);
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u8bfe\u7a0b-\u67e5\u8be2")
    @GetMapping(value={"/search"})
    public ResponseData<LayuiGridData<CourseItemVo>> searchItemsByKeyword(CoursePageParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        param.setLoginWide(this.getLoginWide());
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setReqSource(null);
        }
        LayuiGridData layuiGridData = this.courseItemManagerService.searchItemsByKeyword(param);
        return new ResponseData((Object)layuiGridData);
    }

    private Integer getLoginWide() {
        Set<Integer> list = ShiroUtil.getLoginUserSystemWideList();
        Integer wide = null;
        if (CollUtil.contains(list, (Object)0)) {
            wide = 0;
        }
        if (CollUtil.contains(list, (Object)0) && CollUtil.contains(list, (Object)1)) {
            wide = 1;
        }
        if (CollUtil.contains(list, (Object)0) && CollUtil.contains(list, (Object)1) && CollUtil.contains(list, (Object)2)) {
            wide = 2;
        }
        return wide;
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u8bfe\u7a0b-\u67e5\u8be2\uff08\u57f9\u8bad\u65b0\u589e\u7f16\u8f91\u7528\uff09")
    @GetMapping(value={"/search/training"})
    public ResponseData<LayuiGridData<CourseItemVo>> searchItemsByKeywordForEditingTraining(CoursePageParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setReqSource(null);
        }
        LayuiGridData layuiGridData = this.courseItemManagerService.searchItemsByKeyword(param);
        return new ResponseData((Object)layuiGridData);
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u8bfe\u7a0b-\u8bfe\u65f6\u7edf\u8ba1")
    @GetMapping(value={"/countClassHours"})
    public ResponseData<ClassHourstatisticsVo> countClassHours(ClassHourStatisticsParam param) {
        return ResponseData.success((Object)this.courseItemManagerService.countClassHoursV1(param));
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u8bfe\u7a0b-\u8bfe\u65f6\u7edf\u8ba1")
    @GetMapping(value={"/countClassHours/v3221"})
    public ResponseData<List<ClassHourstatisticsVo>> countClassHoursV3_2_2_1(ClassHourStatisticsParam param) {
        return ResponseData.success((Object)this.courseItemManagerService.countClassHoursV3_2_2_1(param));
    }

    @ApiOperationSupport(order=2)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u8bfe\u7a0b-\u6dfb\u52a0")
    @Log(title="\u8bfe\u7a0b-\u6dfb\u52a0", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"/add"})
    public ResponseData add(@RequestBody CourseItemAddParam param) {
        this.courseItemManagerService.addCourseItem(param);
        return ResponseData.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @ApiOperationSupport(order=3)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u8bfe\u7a0b-\u6dfb\u52a0\u91cd\u70b9\u8bfe\u7a0b\u8349\u7a3f")
    @Log(title="\u8bfe\u7a0b-\u6dfb\u52a0\u91cd\u70b9\u8bfe\u7a0b\u8349\u7a3f", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_add)
    @PostMapping(value={"/addKeyCourse"})
    public ResponseData addKeyCourse(@RequestBody KeyCourseAddParam param) {
        this.courseItemManagerService.addKeyCourse(param);
        return ResponseData.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @ApiOperationSupport(order=5)
    @RequiresPermissions(value={"training_course:view", "training:view"}, logical=Logical.OR)
    @ApiOperation(value="\u8bfe\u7a0b-\u67e5\u770b\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="courseItemId", value="\u8bfe\u7a0bid")})
    @GetMapping(value={"/detail"})
    public ResponseData<CourseItemVo> detail(Long courseItemId, Boolean ifIncludeQuestNum) {
        CourseItemVo courseItemVo = this.courseItemManagerService.getCourseItemById(courseItemId);
        if (ifIncludeQuestNum == null || ifIncludeQuestNum.booleanValue()) {
            // empty if block
        }
        return new ResponseData((Object)courseItemVo);
    }

    @ApiOperationSupport(order=6)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u8bfe\u7a0b-\u7f16\u8f91-\u4e00\u6b21\u6027\u7f16\u8f91\u8bfe\u7a0b")
    @Log(title="\u8bfe\u7a0b-\u7f16\u8f91-\u4e00\u6b21\u6027\u7f16\u8f91\u8bfe", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/editFullInfo"})
    public ResponseData editFullInfo(@RequestBody CourseItemEditFullInfoParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkParam = new CheckEditPermissionParam().setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setAreaId(userInfo.getAreaId()).setItemId(param.getId());
        this.courseItemManagerService.checkOneEditPermission(checkParam);
        this.courseItemManagerService.editFullCourseItemInfo(param);
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperationSupport(order=11)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u8bfe\u7a0b-\u5220\u9664")
    @Log(title="\u8bfe\u7a0b-\u5220\u9664", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"/edit/delete"})
    public ResponseData delete(@RequestBody IdParam idParam) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkParam = new CheckEditPermissionParam().setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setAreaId(userInfo.getAreaId()).setUserOptRole(userInfo.getOperationRole()).setItemId(idParam.getId());
        this.courseItemManagerService.checkOneEditPermission(checkParam);
        this.courseItemManagerService.delete(idParam.getId());
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperationSupport(order=12)
    @RequiresPermissions(value={"training_course:edit"})
    @Log(title="\u8bfe\u7a0b-\u6279\u91cf\u7ba1\u7406\uff081\uff1a\u542f\u7528\u30012\uff1a\u7981\u7528\u30013\uff1a\u5220\u9664\uff09", logModule=LogModuleTypeEnum.class_course, type=LogTypeEnum.type_opt)
    @PostMapping(value={"/edit/batchOpt"})
    public ResponseData batchOpt(@RequestBody List<CourseItemSingleOptParam> paramList) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkParam = new CheckEditPermissionParam().setUid(userInfo.getId()).setAreaId(userInfo.getAreaId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setItemIdList(paramList.stream().map(CourseItemSingleOptParam::getCourseItemId).collect(Collectors.toList()));
        this.courseItemManagerService.checkBatchEditPermission(checkParam);
        List courseItemBatchOptVoList = this.courseItemManagerService.batchOpt(paramList);
        if (CollUtil.isNotEmpty((Collection)courseItemBatchOptVoList)) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u63d0\u793a\u8fdb\u884c\u4fee\u6539", (Object)courseItemBatchOptVoList);
        }
        return ResponseData.success();
    }

    @ApiOperationSupport(order=1200)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u8bfe\u7a0b-\u8bfe\u7a0b\u5339\u914d\u6d4b\u8bd5")
    @PostMapping(value={"/test"})
    public ResponseData<List<CourseItemVo>> test(@RequestBody MatchCourseParam param) {
        return new ResponseData((Object)this.courseItemManagerService.matchCourse(param));
    }
}

