/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.course;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.enums.GroupTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupChangeStatusParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupEditParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupSingleOptParam;
import cn.smarthse.radiationTraining.modules.training.param.course.DefaultCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupAddItemsParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupDeleteItemParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupPageParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseGroupManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=20, author="\u9648\u4eae")
@Api(tags={"\u8bfe\u7a0b\u7ec4\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/course/group"})
public class CourseGroupController
extends ControllerSupport {
    @DubboReference(check=false)
    private ICourseGroupManagerProviderService courseGroupManagerService;

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view", "training:view"})
    @ApiOperation(value="\u7ec4-\u5173\u952e\u8bcd\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/search"})
    public ResponseData<LayuiGridData<CourseGroupVo>> searchGroup(GroupPageParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        param.setLoginWide(this.getLoginWide());
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setCreateBy(userInfo.getId());
        }
        LayuiGridData search = this.courseGroupManagerService.searchGroupsByKeyword(param);
        return new ResponseData((Object)search);
    }

    private Integer getLoginWide() {
        Set<Integer> list = ShiroUtil.getLoginUserSystemWideList();
        Integer wide = null;
        if (CollUtil.contains(list, (Object)0)) {
            wide = 0;
        }
        if (CollUtil.contains(list, (Object)0) && CollUtil.contains(list, (Object)1)) {
            wide = 1;
        }
        if (CollUtil.contains(list, (Object)0) && CollUtil.contains(list, (Object)1) && CollUtil.contains(list, (Object)2)) {
            wide = 2;
        }
        return wide;
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view", "training:view"})
    @ApiOperation(value="\u7ec4-\u5173\u952e\u8bcd\u6a21\u7cca\u67e5\u8be2-\u57f9\u8bad\u65b0\u589e\u7f16\u8f91\u7528")
    @GetMapping(value={"/search/training"})
    public ResponseData<LayuiGridData<CourseGroupVo>> searchGroupForEditingTraining(GroupPageParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setCreateBy(userInfo.getId());
        }
        LayuiGridData search = this.courseGroupManagerService.searchGroupsByKeyword(param);
        return new ResponseData((Object)search);
    }

    @ApiOperationSupport(order=1)
    @RequiresPermissions(value={"training_course:view", "training:view"})
    @ApiOperation(value="\u7ec4-\u83b7\u53d6\u9ed8\u8ba4\u8bfe\u7a0b\u7ec4")
    @GetMapping(value={"/default"})
    public ResponseData<List<CourseGroupVo>> getDefaultCourse(DefaultCourseParam param) {
        List voList = this.courseGroupManagerService.getDefaultCourse(param);
        return new ResponseData((Object)voList);
    }

    @ApiOperationSupport(order=2)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u7ec4-\u5173\u952e\u8bcd\u6a21\u7cca\u67e5\u8be2-\u83b7\u53d6\u7ec4\u540d\u548c\u7ec4id")
    @GetMapping(value={"/getIdsAndNamesByKeyword"})
    public ResponseData getIdsAndNamesByKeyword(String keyword) {
        List idsAndNamesByKeyword = this.courseGroupManagerService.getIdsAndNamesByKeyword(keyword);
        return new ResponseData((Object)idsAndNamesByKeyword);
    }

    @ApiOperationSupport(order=3)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u7ec4-\u67e5\u770b\u7ec4\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7ec4\u7f16\u53f7")})
    @GetMapping(value={"/detail"})
    public ResponseData<CourseGroupVo> getGroupDetailById(Long id) {
        CourseGroupVo vo = this.courseGroupManagerService.getGroupDetailById(id);
        String msg = vo == null ? "\u65e0\u6570\u636e" : "\u67e5\u8be2\u6210\u529f";
        return new ResponseData(msg, (Object)vo);
    }

    @ApiOperationSupport(order=4)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u6dfb\u52a0\u7ec4")
    @PostMapping(value={"/add"})
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u65b0\u589e", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_add)
    public ResponseData addGroup(@RequestBody CourseGroupAddParam param) {
        boolean flag;
        UserInfo userInfo = ShiroUtil.getUserInfo();
        if (!AccountUtil.isSpecifiedUserName((String)userInfo.getUsername())) {
            param.setType(GroupTypeEnum.UNIVERSAL.getValue());
        }
        String msg = (flag = this.courseGroupManagerService.addGroup(param)) ? "\u6dfb\u52a0\u6210\u529f" : "\u6dfb\u52a0\u5931\u8d25";
        ResponseStateEnum state = flag ? ResponseStateEnum.success : ResponseStateEnum.fail;
        return new ResponseData(state, msg);
    }

    @ApiOperationSupport(order=4)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u6dfb\u52a0\u8bfe\u7a0b")
    @PostMapping(value={"/addItem"})
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u8bfe\u7a0b\u7ec4\u9009\u62e9\u8bfe\u7a0b", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_edit)
    public ResponseData addItem(@RequestBody GroupAddItemsParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkEditPermissionParam = new CheckEditPermissionParam();
        checkEditPermissionParam.setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setGroupId(param.getGroupId()).setGroupType(param.getType());
        this.courseGroupManagerService.checkEditPermission(checkEditPermissionParam);
        this.courseGroupManagerService.addCourseItem(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=5)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u7f16\u8f91\u7ec4")
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u7f16\u8f91", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/edit"})
    public ResponseData editGroup(@RequestBody CourseGroupEditParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkEditPermissionParam = new CheckEditPermissionParam();
        checkEditPermissionParam.setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setGroupId(param.getId()).setGroupType(param.getType());
        this.courseGroupManagerService.checkEditPermission(checkEditPermissionParam);
        this.courseGroupManagerService.editGroup(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=6)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u542f\u7528\u3001\u7981\u7528")
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u542f\u7528\u3001\u7981\u7528", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/editStatus"})
    public ResponseData editGroupStatus(@RequestBody CourseGroupChangeStatusParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkEditPermissionParam = new CheckEditPermissionParam();
        checkEditPermissionParam.setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setGroupId(param.getId());
        this.courseGroupManagerService.checkEditPermission(checkEditPermissionParam);
        boolean flag = this.courseGroupManagerService.editGroupStatus(param);
        String msg = flag ? "\u72b6\u6001\u4fee\u6539\u6210\u529f" : "\u72b6\u6001\u4fee\u6539\u5931\u8d25";
        ResponseStateEnum state = flag ? ResponseStateEnum.success : ResponseStateEnum.fail;
        return new ResponseData(state, msg);
    }

    @ApiOperationSupport(order=7)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u5220\u9664\u7ec4")
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u5220\u9664", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"/delete"})
    public ResponseData deleteGroup(@RequestBody IdParam id) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkEditPermissionParam = new CheckEditPermissionParam();
        checkEditPermissionParam.setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setGroupId(id.getId());
        this.courseGroupManagerService.checkEditPermission(checkEditPermissionParam);
        boolean flag = this.courseGroupManagerService.delete(id.getId());
        String msg = flag ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        ResponseStateEnum state = flag ? ResponseStateEnum.success : ResponseStateEnum.fail;
        return new ResponseData(state, msg);
    }

    @ApiOperationSupport(order=7)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u5220\u9664\u8bfe\u7a0b")
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u7ec4\u5220\u9664\u8bfe\u7a0b", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/deleteItem"})
    public ResponseData deleteItem(@RequestBody GroupDeleteItemParam param) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkEditPermissionParam = new CheckEditPermissionParam();
        checkEditPermissionParam.setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setGroupId(param.getGroupId());
        this.courseGroupManagerService.checkEditPermission(checkEditPermissionParam);
        this.courseGroupManagerService.deleteCoruseItem(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=7)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u5220\u9664\u8bfe\u7a0b-\u6279\u91cf")
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u8bfe\u7a0b\u7ec4\u6279\u91cf\u5220\u9664\u8bfe\u7a0b", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/deleteItem/batch"})
    public ResponseData deleteItemBatch(@RequestBody List<GroupDeleteItemParam> paramList) {
        UserInfo userInfo = ShiroUtil.getUserInfo();
        CheckEditPermissionParam checkEditPermissionParam = new CheckEditPermissionParam();
        checkEditPermissionParam.setUid(userInfo.getId()).setUname(userInfo.getUsername()).setUserFrom(userInfo.getUserFrom()).setUserOptRole(userInfo.getOperationRole()).setGroupId(paramList.get(0).getGroupId());
        this.courseGroupManagerService.checkEditPermission(checkEditPermissionParam);
        this.courseGroupManagerService.deleteCoruseItemBatch(paramList);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=8)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u7ec4-\u9884\u89c8\u67d0\u4e2a\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7ec4\u7f16\u53f7")})
    @GetMapping(value={"/previewByGroupId"})
    public ResponseData<CourseGroupVo> previewByGroupId(Long id) {
        CourseGroupVo vo = this.courseGroupManagerService.previewByGroupId(id);
        String msg = vo == null ? "\u65e0\u6570\u636e" : "\u67e5\u8be2\u6210\u529f";
        return new ResponseData(msg, (Object)vo);
    }

    @ApiOperationSupport(order=9)
    @RequiresPermissions(value={"training_course:view"})
    @ApiOperation(value="\u7ec4-\u9884\u89c8\u67d0\u4e2a\u8bfe\u7a0b\u7684\u6240\u6709\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bfe\u7a0b\u7f16\u53f7")})
    @GetMapping(value={"/previewByCourseItemId"})
    public ResponseData<List<CourseGroupVo>> previewByItemId(Long id) {
        List vos = this.courseGroupManagerService.previewByItemId(id);
        String msg = vos.size() == 0 ? "\u65e0\u6570\u636e" : "\u67e5\u8be2\u6210\u529f";
        return new ResponseData(msg, (Object)vos);
    }

    @ApiOperationSupport(order=10)
    @RequiresPermissions(value={"training_course:edit"})
    @ApiOperation(value="\u7ec4-\u6279\u91cf\u64cd\u4f5c")
    @Log(title="\u8bfe\u7a0b\u7ec4\u7ba1\u7406-\u6279\u91cf\u542f\u7528\u7981\u7528", logModule=LogModuleTypeEnum.class_group, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/edit/batchOpt"})
    public ResponseData batchOpt(@RequestBody List<CourseGroupSingleOptParam> paramList) {
        List ids = paramList.stream().map(v -> v.getCourseGroupId()).collect(Collectors.toList());
        UserInfo userInfo = ShiroUtil.getUserInfo();
        this.courseGroupManagerService.checkEditPermission(userInfo.getId(), userInfo.getUsername(), userInfo.getUserFrom(), userInfo.getOperationRole(), ids);
        List courseGroupBatchOptVos = this.courseGroupManagerService.batchOpt(paramList);
        if (CollUtil.isNotEmpty((Collection)courseGroupBatchOptVos)) {
            throw new ServiceException(Integer.valueOf(-1), "\u7f16\u8f91\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u5931\u8d25\u63d0\u793a\u8fdb\u884c\u4fee\u6539", (Object)courseGroupBatchOptVos);
        }
        return ResponseData.success();
    }
}

